% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define_S4_class_assess_RCMdata.R
\docType{class}
\name{RCMdata-class}
\alias{RCMdata-class}
\alias{RCMdata}
\title{Class-\code{RCMdata}}
\description{
An S4 class for the data inputs into \link{RCM}.
}
\section{Slots}{

\describe{
\item{\code{Chist}}{Either a vector of historical catch, should be of length \code{OM@nyears}, or if there are multiple fleets,
a matrix of \code{OM@nyears} rows and \code{nfleet} columns.
Ideally, the first year of the catch series represents unfished conditions (see also slot \code{C_eq}).}

\item{\code{C_sd}}{Same dimension as \code{Chist}. Lognormal distribution standard deviations (by year and fleet) for the catches in \code{Chist}.
If not provided, the default is 0.01. Not used if \code{RCM(condition = "catch2")}.}

\item{\code{Ehist}}{A vector of historical effort, should be of length \code{OM@nyears}, or if there are multiple fleets:
a matrix of \code{OM@nyears} rows and \code{nfleet} columns. See also slot \code{E_eq}).}

\item{\code{CAA}}{Fishery age composition matrix with \code{nyears} rows and \code{OM@maxage+1} columns, or if multiple fleets:
an array with dimension: \verb{nyears, OM@maxage+1, nfleet}. Enter \code{NA} for years without any data.
Raw numbers will be converted to annual proportions (see slot \code{CAA_ESS} for sample sizes).}

\item{\code{CAA_ESS}}{Annual sample size (for the multinomial distribution) of the fishery age comps.
A vector of length \code{OM@nyears}, or if there are multiple fleets: a matrix of \code{OM@nyears} rows and \code{nfleet} columns.
Enter zero for years without observations.
An annual cap to the ESS, e.g., 50, can be calculated with something like: \code{pmin(apply(CAA, c(1, 3), sum, na.rm = TRUE), 50)}.
By default,}

\item{\code{CAL}}{Fishery length composition matrix with \code{nyears} rows and \code{n_bin} columns (indexing the length bin), or
if multiple fleets: an array with dimension: \verb{nyears, n_bin, nfleets}. Enter \code{NA} for years without any data.
Raw numbers will be converted to annual proportions (see slot \code{CAL_ESS} for sample sizes).}

\item{\code{CAL_ESS}}{Annual sample size (for the multinomial distribution) of the fishery length comps.
Same dimension as \code{CAA_ESS}.}

\item{\code{length_bin}}{\itemize{
\item A vector (length \code{n_bin}) for the midpoints of the length bins for \code{CAL} and \code{IAL}, as well as the population model, if all bin widths are equal in size.
If length bins are unequal in width, then provide a vector of the boundaries of the length bins (vector of length \code{n_bin + 1}).
}}

\item{\code{MS}}{Mean mean size (either mean length or mean weight) observations from the fishery. Same dimension as \code{Chist}.
Generally, mean lengths should not be used alongside \code{CAL}, unless mean length and length comps are independently sampled.}

\item{\code{MS_type}}{A character (either \code{"length"} (default) or \code{"weight"}) to denote the type of mean size data.}

\item{\code{MS_cv}}{The coefficient of variation of the observed mean size. If there are multiple fleets, a vector of length \code{nfleet}.
Default is 0.2.}

\item{\code{Index}}{Index of abundance. Enter \code{NA} for missing values. A vector length \code{OM@nyears}, or if there are multiple surveys:
a matrix of \code{OM@nyears} rows and \code{nsurvey} columns.}

\item{\code{I_sd}}{A vector or matrix of standard deviations (lognormal distribution) for the indices corresponding to the entries in \code{Index}.
Same dimension as \code{Index}. If not provided, this function will use values from \code{OM@Iobs}.}

\item{\code{IAA}}{Index age composition data, an array of dimension \verb{nyears, maxage+1, nsurvey}.
Raw numbers will be converted to annual proportions (see \code{IAA_ESS} for sample sizes).}

\item{\code{IAA_ESS}}{Annual sample size (for the multinomial distribution) of the index age comps.
A vector of length \code{OM@nyears}. If there are multiple indices: a matrix of \code{OM@nyears} rows and \code{nsurvey} columns.}

\item{\code{IAL}}{Index length composition data, an array of dimension \verb{nyears, n_bin, nsurvey}.
Raw numbers will be converted to annual proportions (see slot \code{IAL_ESS} to enter sample sizes).}

\item{\code{IAL_ESS}}{Annual sample size (for the multinomial distribution) of the index length comps.
Same dimension as \code{IAA_ESS}.}

\item{\code{C_eq}}{Vector of length \code{nfleet} for the equilibrium catch for each fleet in \code{Chist} prior to the first year of the operating model.
Zero (default) implies unfished conditions in year one. Otherwise, this is used to estimate depletion in the first year of the data. Alternatively,
if one has a full CAA matrix, one could instead estimate "artificial" rec devs to generate the initial numbers-at-age (and hence initial depletion)
in the first year of the model (see additional arguments in \link{RCM}).}

\item{\code{C_eq_sd}}{\itemize{
\item A vector of standard deviations (lognormal distribution) for the equilibrium catches in \code{C_eq}.
Same dimension as \code{C_eq}. If not provided, the default is 0.01. Only used if \code{RCM(condition = "catch")}.
}}

\item{\code{E_eq}}{The equilibrium effort for each fleet in \code{Ehist} prior to the first year of the operating model.
Zero (default) implies unfished conditions in year one. Otherwise, this is used to estimate depletion in the first year of the data.}

\item{\code{abs_I}}{An integer vector length \code{nsurvey} to indicate which indices are in absolute magnitude. Use \code{1} to set \code{q = 1},
otherwise use 0 (default) to estimate q.}

\item{\code{I_units}}{An integer vector to indicate whether indices are biomass based (1) or abundance-based (0). By default, all are biomass-based.}

\item{\code{age_error}}{A square matrix of \code{maxage + 1} rows and columns to specify ageing error. The \code{aa}-th column assigns a proportion of animals of
true age \code{aa} to observed age \code{a} in the \code{a}-th row. Thus, all rows should sum to 1. Default is an identity matrix (no ageing error).}

\item{\code{sel_block}}{For time-varying fleet selectivity (in time blocks), a integer matrix of \code{nyears} rows and \code{nfleet} columns to assign a selectivity
function to a fleet for certain years. By default, constant selectivity for each individual fleet.
See the \href{https://openmse.com/tutorial-rcm-select/}{selectivity} article for more details.}

\item{\code{Misc}}{A list of miscellaneous inputs. Used internally.}
}}

\seealso{
\link{RCM}
}
\author{
Q. Huynh
}
