% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxode-options.R
\name{rxSuppressMsg}
\alias{rxSuppressMsg}
\title{Respect suppress messages}
\usage{
rxSuppressMsg()
}
\value{
Nothing
}
\description{
This turns on the silent REprintf in C when \code{suppressMessages()} is
turned on. This makes the \code{REprintf} act like \code{messages} in R,
they can be suppressed with \code{suppressMessages()}
}
\examples{

# rxSupressMsg() is called with RxODE()

# Note the errors are output to the console

try(RxODE("d/dt(matt)=/3"),silent=TRUE)

# When using suppressMessages, the output is suppressed

suppressMessages(try(RxODE("d/dt(matt)=/3"),silent=TRUE))

# In RxODE, we use REprintf so that interrupted threads do not crash R
# if there is a user interrupt. This isn't captured by R's messages, but
# This interface allows the `suppressMessages()` to suppress the C printing
# as well

# If you  want to suppress messages from RxODE in other packages, you can use
# this function
}
\author{
Matthew Fidler
}
