% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RxODE.R
\name{rxCompile}
\alias{rxCompile}
\alias{rxCompile.rxModelVars}
\alias{rxCompile.character}
\alias{rxCompile.rxDll}
\alias{rxCompile.RxODE}
\title{Compile a model if needed}
\usage{
rxCompile(
  model,
  dir,
  prefix,
  force = FALSE,
  modName = NULL,
  package = NULL,
  ...
)

\method{rxCompile}{rxModelVars}(
  model,
  dir = NULL,
  prefix = NULL,
  force = FALSE,
  modName = NULL,
  package = NULL,
  ...
)

\method{rxCompile}{character}(
  model,
  dir = NULL,
  prefix = NULL,
  force = FALSE,
  modName = NULL,
  package = NULL,
  ...
)

\method{rxCompile}{rxDll}(model, ...)

\method{rxCompile}{RxODE}(model, ...)
}
\arguments{
\item{model}{This is the ODE model specification.  It can be:
\itemize{
\item a string containing the set of ordinary differential
equations (ODE) and other expressions defining the changes in
the dynamic system.
\item a file name where the ODE system equation is contained
}

An ODE expression enclosed in \verb{\\\{\\\}}

(see also the \code{filename} argument). For
details, see the sections \dQuote{Details} and
\verb{RxODE Syntax} below.}

\item{dir}{This is the model directory where the C file will be
stored for compiling.\preformatted{If unspecified, the C code is stored in a temporary directory,
then the model is compiled and moved to the current directory.
Afterwards the C code is removed.

If specified, the C code is stored in the specified directory
and then compiled in that directory.  The C code is not removed
after the DLL is created in the same directory.  This can be
useful to debug the c-code outputs.
}}

\item{prefix}{is a string indicating the prefix to use in the C
based functions.  If missing, it is calculated based on file
name, or md5 of parsed model.}

\item{force}{is a boolean stating if the (re)compile should be
forced if RxODE detects that the models are the same as already
generated.}

\item{modName}{a string to be used as the model name. This string
is used for naming various aspects of the computations,
including generating C symbol names, dynamic libraries,
etc. Therefore, it is necessary that \code{modName} consists of
simple ASCII alphanumeric characters starting with a letter.}

\item{package}{Package name for pre-compiled binaries.}

\item{...}{Other arguments sent to the \code{\link[=rxTrans]{rxTrans()}}
function.}
}
\value{
An rxDll object that has the following components
\itemize{
\item \code{dll}{DLL path}
\item \code{model}{model specification}
\item \code{.c}{A function to call C code in the correct context from the DLL
using the \code{\link[=.C]{.C()}} function.}
\item \code{.call}{A function to call C code in the correct context from the DLL
using the \code{\link[=.Call]{.Call()}} function.}
\item \code{args}{A list of the arguments used to create the rxDll object.}
}
}
\description{
This is the compilation workhorse creating the RxODE model DLL
files.
}
\seealso{
\code{\link[=RxODE]{RxODE()}}
}
\author{
Matthew L.Fidler
}
