% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dsubbo}
\alias{dsubbo}
\title{Returns density from Subbotin Distribution}
\usage{
dsubbo(x, m = 0, a = 1, b = 2)
}
\arguments{
\item{x}{(numeric) - value in the range \eqn{(-\infty, \infty)} to evaluate
the density.}

\item{m}{(numeric) - location parameter.}

\item{a}{(numeric) - scale parameter. Must be in the range \eqn{(0, \infty)}.}

\item{b}{(numeric) - shape parameter. Must be in the range \eqn{(0, \infty)}.}
}
\value{
a vector containing the values for the densities.
}
\description{
The \code{dsubbo} returns the density at point x for the
Subbotin distribution with parameters \eqn{a}, \eqn{b}, \eqn{m}.
}
\details{
The Subbotin distribution is a exponential power distribution controlled
by three parameters, with formula:
\deqn{f(x;a,b,m) = \frac{1}{A} e^{-\frac{1}{b} |\frac{x-m}{a}|^b}}
with:
\deqn{A = 2ab^{1/b}\Gamma(1+1/b)}
where \eqn{a} is a scale parameter, \eqn{b} controls the tails (lower values
represent fatter tails), and \eqn{m} is a location parameter.
}
