% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stoxLanding.R
\name{StoxLanding}
\alias{StoxLanding}
\title{Convert landing data}
\usage{
StoxLanding(LandingData)
}
\arguments{
\item{LandingData}{Sales-notes data. See \code{\link[RstoxData]{LandingData}}}
}
\value{
\code{\link[RstoxData]{StoxLandingData}}, aggregated landings data.
}
\description{
Convert landing data to the aggregated format \code{\link[RstoxData]{StoxLandingData}}
}
\details{
All columns that are not the ones aggregated (weight), will be used as aggregation variables.

 Correspondences indicate which field a value is derived from, not necessarily verbatim copied.

 Correspondence to LandingData (http://www.imr.no/formats/landinger/v2):
 \describe{
  \item{Species}{Art_kode}
  \item{Year}{Fangstår}
  \item{CatchDate}{SisteFangstdato}
  \item{Gear}{Redskap_kode}
  \item{Area}{Hovedområde_kode}
  \item{Location}{Lokasjon_kode}
  \item{Coastal}{KystHav_kode}
  \item{N62Code}{NordSørFor62GraderNord}
  \item{VesselLength}{StørsteLengde}
  \item{CountryVessel}{Fartøynasjonalitet_kode}
  \item{LandingSite}{Mottaksstasjon}
  \item{CountryLanding}{Landingsnasjon_kode}
  \item{Usage}{HovedgruppeAnvendelse_kode}
  \item{RoundWeight}{Rundvekt}
 }
}
