% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stoxLanding.R
\name{StoxLanding}
\alias{StoxLanding}
\title{Convert landing data}
\usage{
StoxLanding(
  LandingData,
  appendColumns = character(),
  appendColumnsNames = appendColumns
)
}
\arguments{
\item{LandingData}{Sales-notes data. See \code{\link[RstoxData]{LandingData}}}

\item{appendColumns}{character() vector that identifies additional columns in \code{\link[RstoxData]{LandingData}} to append to \code{\link[RstoxData]{StoxLandingData}}.}

\item{appendColumnsNames}{character() vector that defines the names of the columns in 'appendColumns' in the output.}
}
\value{
\code{\link[RstoxData]{StoxLandingData}}, aggregated landings data.
}
\description{
StoX function
 Convert landing data to the aggregated format \code{\link[RstoxData]{StoxLandingData}}
}
\details{
All columns that are not the ones aggregated (weight), will be used as aggregation variables.
 This includes any columns added with 'appendColumns' and may not make much sense for continuous variables.
 
 If 'LandingData' does not contain columns identified by 'appendColumns'. NA columns will be added.

 Correspondences indicate which field a value is derived from, not necessarily verbatim copied.

 Correspondence to LandingData (http://www.imr.no/formats/landinger/v2):
 \describe{
  \item{Species}{Art_kode}
  \item{Year}{Fangstår}
  \item{CatchDate}{SisteFangstdato}
  \item{Gear}{Redskap_kode}
  \item{Area}{Hovedområde_kode}
  \item{SubArea}{Lokasjon_kode}
  \item{Coastal}{KystHav_kode}
  \item{N62Code}{NordSørFor62GraderNord}
  \item{VesselLengthGroup}{Lengdegruppe_kode}
  \item{CountryVessel}{Fartøynasjonalitet_kode}
  \item{LandingSite}{Mottaksstasjon}
  \item{CountryLanding}{Landingsnasjon_kode}
  \item{Usage}{HovedgruppeAnvendelse_kode}
  \item{RoundWeightKilogram}{Rundvekt}
 }
}
