\name{changeArgs.treeoutput}
\alias{changeArgs.treeoutput}
\title{Modify the settings stored in a sampletrees treeoutput object}
\description{
Modify the settings stored in a sampletrees treeoutput object.
}
\details{
 The function changeArgs modifies the settings values from a run of sampletrees (the settings are stored 
 in the runinfo component of the treeoutput object). The format for passing arguments to this function is: TagName=Value. The 
 names are given in the Value section.
}
\usage{
\method{changeArgs}{treeoutput}(object,...)
}
\arguments{
\item{object}{An object of class `treeoutput'}
\item{\ldots}{Optional tag names and the value they should be set to. See Details section.}
}
\value{
Returns an object of class `treeoutput' with the runinfo settings modified as specified. 

The settings names in the runinfo component are:
 \item{RunName}{Run name for the sampletrees run (Default="Run")} 
\item{Seed}{Initial seed for sampletrees run. (Default=NA)} 
\item{DataType}{The type of the data file g=genotype h=haplotype. (Default="h")}
\item{DataFile}{The name of the file containing the haplotype or genotype data. DEFAULT=NA
but the user must change this value before running sampletrees()} 
\item{LocationFile}{The name of the file containing the genomic locations (in base pairs) 
of the SNP markers. Default=NA but the user must change this value before running sampletrees()}
\item{WeightFile}{The name of the file containing the probabilities for sampling each of the 7 
updates. Default=NA but the user must change this value before running sampletrees(). See setWeights for more information.}
\item{FocalPoint}{The location of the focal point. Default=NA but the user must change this value before running sampletrees()} 
\item{ChainLength}{How long to run the chain. (Default=1000)} 
\item{BurnIn}{Discard the first 'BurnIn' samples. (Default=100)}
\item{Thinning}{Return output every 'Thinning'th sample. (Default=1)}
\item{InitialTheta}{Initial value for mutation rate theta. (Default=1)}
\item{MinTheta}{Minimum for Uniform prior for theta. (Default=0.0001)}
\item{MaxTheta}{Maximum for Univorm prior for theta. (Default=10)}
\item{InitialRho}{Initial value for recombination rate rho. (Default=0.0004)}
\item{ScaleRho}{Scale parameter for gamma prior for rho. (Default=0.1)}
\item{ShapeRho}{Shape parameter for gamma prior for rho. (Default=1)}

\item{InitialTreeFile}{Name for a file containing initial tree data for a run of
sampletrees. These are typically available from a previous run of sampletrees. 
If DataType="g", initial haplotype configurations will be taken from this file
rather than one specified by InitialHaploFile. (Default=NA)}
\item{RandomTree}{Indicates whether initial tree generated by randomly connecting
nodes. (Default=FALSE)}
\item{HaploFreqFile}{The name of the file with the haplo frequency estimates to be 
used only if DataType="g". See estimateHapFreqs() for more information. Default=NA 
but user must change this value if DataType is 'g'.} 
\item{InitialHaploFile}{Name for an optional file containing
the initial haplotype configurations for the sampletrees run (optional if DataType="g"). 
Each row of this file corresponds to a haplotype, there are 2 rows/individual 
and rows must be 
in the same order as in DataFile. (Default=NA)}  
\item{HaploListFile}{Name for a optional file containing
a list of likely haplotypes (optional if DataType="g"). Each row corresponds to a haplotype. 
(Default=NA)}
}
\examples{
#\dontrun{
 #system.file("Examples/example_g_pars",package="Rsampletrees")
filename=paste(path.package("Rsampletrees"),"/extdata/example_g_pars",sep="")
runpars=readArgs(filename, check=FALSE)
#paste(system.file(package="Rsampletrees"),runpars$RunName, sep="/")
runname=paste(path.package("Rsampletrees"),"extdata",runpars$RunName, sep="/")
runpars=changeArgs(runpars, RunName=runname)
results=readOutput(argobj=runpars)
results=changeArgs(results, RunName="NewName")
#}
}
\references{Burkett KM, McNeney B, Graham J. Sampletrees and Rsampletrees: sampling gene genealogies conditional on SNP genotype data. Bioinformatics. 32:1580-2, 2016}
\author{Kelly Burkett}
\seealso{changeArgs.pars, checkArgs}
