% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform_gibbs_samples.R
\name{transform_gibbs_samples}
\alias{transform_gibbs_samples}
\title{Transformation of Gibbs samples.}
\usage{
transform_gibbs_samples(gibbs_samples, R, B, Q, normalization)
}
\arguments{
\item{gibbs_samples}{The output of \link{gibbs_sampling}.}

\item{R}{The number of iterations of the Gibbs sampler.}

\item{B}{The length of the burn-in period, i.e. a non-negative number of samples to
be discarded.}

\item{Q}{The thinning factor for the Gibbs samples, i.e. only every \code{Q}th
sample is kept.}

\item{normalization}{An object of class \code{RprobitB_normalization}.}
}
\value{
An object of class \code{RprobitB_gibbs_samples}, i.e. a list of transformed
Gibbs samples. Each element is a list, containing (if available) the
Gibbs samples for \code{s}, \code{alpha}, \code{b}, \code{Omega}, and
\code{Sigma}:
\itemize{
\item \code{gibbs_samples}:
The function input \code{gibbs_samples}.
\item \code{gibbs_samples_n}:
A list of normalized samples based on \code{normalization}.
\item \code{gibbs_samples_nb}:
A list of normalized and burned samples based on \code{normalization} and \code{B}.
\item \code{gibbs_samples_nt}:
A list of normalized and thinned samples based on \code{normalization} and \code{Q}
\item \code{gibbs_samples_nbt}:
A list of normalized, burned and thinned samples based on \code{normalization},
\code{B} and \code{Q}
}
}
\description{
This function normalizes, burns and thins the Gibbs samples.
}
\keyword{internal}
