\name{getConditionReductDecisionTable}
\alias{getConditionReductDecisionTable}
\title{GET CONDITION REDUCT'S DECISION TABLE}
\description{Accessor method for obtaining the Decision Table object of a slot of a Condition Reduct object.}
\usage{
getConditionReductDecisionTable(object)
}
\arguments{
  \item{object}{A Condition Reduct object}
}
\value{It returns the Decision Table object of the Condition Reduct object.}
\references{Pawlak, Zdzislaw 1991 \emph{Rough Sets: Theoretical Aspects of Reasoning About Data} Dordrecht: Kluwer Academic Publishing.}
\author{Alber Sanchez \email{alber.sanchez@uni-muenster.de}}
\seealso{
  \code{\link{ConditionReduct-class}}
}
\examples{
exampleMatrix2 <- matrix(c(1,1,0,1,1,2,2,0,0,0,1,1,1,2,0,0,0,
0,0,0,2,1,0,0,1,2,2,2,1,1,0,0,2,2,2),ncol = 5)
dt <- new(Class="DecisionTable",decisionTable = exampleMatrix2)
cr <- new(Class="ConditionReduct",decisionTable = dt,columnIds=c(1,2,3,4,5))
crdt <- getConditionReductDecisionTable(cr)
}
\keyword{logic}
\keyword{rough}
\keyword{set}
