\name{computeCore}
\alias{computeCore}
\title{COMPUTE CORE}
\description{It computes the core conditions of a Decision Table object using a Discernibility Matrix object.}
\usage{
computeCore(object)
}
\arguments{
  \item{object}{A Discernibility Matrix object}
}
\value{It returns a numeric vector indicating the columns ids which are the core of the Decision Table object from which the Discernibility Matrix object was created.}
\references{Pawlak, Zdzislaw 1991 \emph{Rough Sets: Theoretical Aspects of Reasoning About Data} Dordrecht: Kluwer Academic Publishing.}
\author{Alber Sanchez \email{alber.sanchez@uni-muenster.de}}
\seealso{
  \code{\link{DiscernibilityMatrix-class}},\code{\link{computeDiscernibilityMatrix}},\code{\link{findFirstConditionReduct}},\code{\link{findSmallestReductFamilyFromCore}},\code{\link{findAllReductsFromCore}}}
\examples{
exampleMatrix2 <- matrix(c(1,1,0,1,1,2,2,0,0,0,1,1,1,2,0,
0,0,0,0,0,2,1,0,0,1,2,2,2,1,1,0,0,2,2,2),ncol = 5)
disMatDT <- new(Class="DecisionTable",decisionTable = exampleMatrix2)
dm <- computeDiscernibilityMatrix(disMatDT)
core <- computeCore(dm)
}
\keyword{logic}
\keyword{rough}
\keyword{set}
