% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RFPE.R
\name{lmrobdetMM.RFPE}
\alias{lmrobdetMM.RFPE}
\title{Robust Final Prediction Error}
\usage{
lmrobdetMM.RFPE(object, scale = NULL)
}
\arguments{
\item{object}{the \code{MM} element (of class \code{\link{lmrob}}) in an object of class \code{\link{lmrobdetMM}}.}

\item{scale}{a numeric value specifying the scale estimate used to compute the RFPE. Usually this 
should be the scale estimate from an encompassing model. If \code{NULL}, the scale estimate in 
\code{object} is used.}
}
\value{
the robust final prediction error (numeric).
}
\description{
This function computes the robust Final Prediction Errors (RFPE) for a robust regression fit using M-estimates.
It is used internally by \code{\link{step.lmrobdetMM}} and not meant to be used
directly.
}
\references{
\url{http://www.wiley.com/go/maronna/robust}
}
\seealso{
\code{\link{lmrobdetMM}}
}
\author{
Victor Yohai, \email{victoryohai@gmail.com}, Matias Salibian-Barrera, \email{matias@stat.ubc.ca}
}
