% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pa.R
\name{pa}
\alias{pa}
\alias{PA}
\title{Parallel analysis}
\usage{
pa(
  data = NULL,
  n = NULL,
  nv = NULL,
  nreps = 1000,
  alpha = 0.05,
  crit = NULL,
  ...
)
}
\arguments{
\item{data}{a data.frame.}

\item{n}{the number of subjects.}

\item{nv}{the number of variables.}

\item{nreps}{the number of replications.}

\item{alpha}{type I error rate.}

\item{crit}{critical values to compare the eigenvalues.}

\item{...}{other arguments}
}
\value{
nfactors (if data is supplied) and sampled eigenvalues
}
\description{
Parallel analysis
}
\examples{
pa(ex_2factors, n = 42)
pa(n = 10, nv = 2, nreps = 100)
}
\references{
Horn, J. L. (1965). A rationale and test for the number of factors in factor analysis. \emph{Psychometrika}, \emph{30}(2), 179–185. \doi{10.1007/BF02289447}
}
