% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsolve_CGS.R
\name{lsolve.cgs}
\alias{lsolve.cgs}
\title{Conjugate Gradient Squared method}
\usage{
lsolve.cgs(A, B, xinit = NA, reltol = 1e-05, maxiter = 10000,
  preconditioner = diag(ncol(A)), adjsym = TRUE, verbose = TRUE)
}
\arguments{
\item{A}{an \code{(m-by-n)} dense or sparse matrix. See also \code{\link[Matrix]{sparseMatrix}}.}

\item{B}{a vector of length \code{m} or an \code{(m-by-k)} matrix (dense or sparse) for solving \code{k} systems simultaneously.}

\item{xinit}{a length-\code{n} vector for initial starting point. \code{NA} to start from a random initial point near 0.}

\item{reltol}{tolerance level for stopping iterations.}

\item{maxiter}{maximum number of iterations allowed.}

\item{preconditioner}{an \code{(n-by-n)} preconditioning matrix; default is an identity matrix.}

\item{adjsym}{a logical; \code{TRUE} to symmetrize the system by transforming the system into normal equation, \code{FALSE} otherwise.}

\item{verbose}{a logical; \code{TRUE} to show progress of computation.}
}
\value{
a named list containing \describe{
\item{x}{a solution of length \code{n}.}
\item{iter}{the number of iterations required.}
\item{errors}{a vector of errors for stopping criterion.}
}
}
\description{
Conjugate Gradient Squared(CGS) method is an extension of Conjugate Gradient method where the system
is symmetric and positive definite. It aims at achieving faster convergence using an idea of
contraction operator twice. For a square matrix \eqn{A},it is required to be symmetric and positive definite.
For an overdetermined system where \code{nrow(A)>ncol(A)},
it is automatically transformed to the normal equation. Underdetermined system -
\code{nrow(A)<ncol(A)} - is not supported. Preconditioning matrix \eqn{M}, in theory, should be symmetric and positive definite
with fast computability for inverse, though it is not limited until the solver level.
}
\examples{
## Overdetermined System
A = matrix(rnorm(10*5),nrow=10)
x = rnorm(5)
b = A\%*\%x

out1 = lsolve.cg(A,b)
out2 = lsolve.cgs(A,b)
matout = cbind(matrix(x),out1$x, out2$x);
colnames(matout) = c("true x","CG result", "CGS result")
print(matout)

}
\references{
\insertRef{sonneveld_cgs_1989}{Rlinsolve}
}
