\name{cavendish}
\docType{data}
\alias{cavendish}
\title{
Cavendish's 1798 determinations of the density of the earth
}
\description{
Newton's law of gravitation states that the forces of
attraction (f) between two particles of matter is given by
the formula f=mm'/(r**2), where m and m' are their
respective masses, r the distance between their centers of
gravity, and G is the gravitational constant, independent
of the kind of matter or intervening medium. From the
late eighteenth through nineteenth centuries, a large
number of experiments were performed in order to determine
G. These experiments were usually designed to determine
the earth's attraction of masses and described as
experiments to determine the mean density of the earth: if
the earth is supposed spherical with radius R and g is the
acceleration toward the earth due to gravity, then
Newton's law becomes dG=3g/(4(pi)R), where d is the mean
density (g/ccm) of the earth. Since g and R could be
supposed known, determination of d could be viewed as
equivalent to determination of G.

Of all these early experiments, that of Cavendish,
performed in 1798 using a torsion balance devised by
Michell, is generally considered the best. The
completeness of his description of his experiments and the
excellence of his methods are often described as an ideal
example of scientific experimentation. Cavendish
concluded his memoir by presenting 29 determinations of
the mean density of the earth. After the 6th of these
determinations, Cavendish changed his experimental
apparatus by replacing a suspension wire by one that was
stiffer. Another interesting feature of the data is that
Cavendish calculated the sample mean incorrectly: somehow
he used 5.88 instead of 4.88 for the 3rd value. This was
first noticed by Baily in 1843 but overlooked by Laplace's
analysis of the data in 1820. The "true value" of d is
5.517 (1977 Encyclopedia Britannica).

The data and above description were taken from Stigler
(1977, The Annals of Statistics, p. 1055-1098) who
obtained it from The Laws of Gravitation edited by A. S.
Mackenzie.
}
\format{
  A numeric vector with 29 values.
}
\examples{
plot(cavendish)
}
\keyword{datasets}
