% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbase.pdist.R
\name{rbase.pdist}
\alias{rbase.pdist}
\title{Pairwise Geodesic Distances of a Data Set}
\usage{
rbase.pdist(input, parallel = FALSE)
}
\arguments{
\item{input}{a S3 object of \code{riemdata} class, whose \code{$data} element is of length \eqn{n}. See \code{\link{riemfactory}} for more details.}

\item{parallel}{a flag for enabling parallel computation.}
}
\value{
an \eqn{(n\times n)} matrix of pairwise distances.
}
\description{
Geodesic distance \eqn{\rho(x,y)} is the length of (locally) shortest path 
connecting two points \eqn{x,y\in\mathcal{M}}. Some manifolds have closed-form expression, while 
others need numerical approximation.
}
\examples{
\dontrun{
### Generate 10 2-frames in R^4
ndata = 10
data = array(0,c(4,2,ndata))
for (i in 1:ndata){
  tgt = matrix(rnorm(4*4),nrow=4)
  data[,,i] = qr.Q(qr(tgt))[,1:2]
}

## Compute Pairwise Distances as if for Grassmann and Stiefel Manifold
A = rbase.pdist(riemfactory(data,name="grassmann"))
B = rbase.pdist(riemfactory(data,name="stiefel"))

## Visual Comparison in Two Cases
par(mfrow=c(1,2), pty="s")
image(pracma::flipud(A), col=gray((0:100)/100), main="Grassmann")
image(pracma::flipud(B), col=gray((0:100)/100), main="Stiefel")
}

}
