% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chi_test_cont.R
\name{chi_test_cont}
\alias{chi_test_cont}
\title{This function performs a number of chi-square gof tests for continuous data}
\usage{
chi_test_cont(
  x,
  pnull,
  w = function(x) -99,
  phat = function(x) -99,
  qnull = NA,
  nbins = c(50, 10),
  rate = 0,
  Range = c(-99999, 99999),
  minexpcount = 5,
  ChiUsePhat = TRUE,
  allbins
)
}
\arguments{
\item{x}{data set}

\item{pnull}{cdf under the null hypothesis}

\item{w}{function to find weights of observations, returns -99 if data is unweighted}

\item{phat}{=function(x) -99, estimated parameters, or starting values of multi-D minimum chi square minimization, or -99 if no estimation is done}

\item{qnull}{=NA quantile function, if available}

\item{nbins}{=c(50, 10) number of bins for chi-square tests}

\item{rate}{=0, rate of Poisson if sample size is random}

\item{Range}{=c(-99999, 99999) limits of possible observations, if any}

\item{minexpcount}{=5 minimal expected bin count required}

\item{ChiUsePhat}{=TRUE, if TRUE param is estimated parameters and no minimization is used}

\item{allbins}{set of bins to use}
}
\value{
A numeric matrix of test statistics, degrees of freedom and p.values
}
\description{
This function performs a number of chi-square gof tests for continuous data
}
