\name{ResultsVC-class}
\Rdversion{1.1}
\docType{class}
\alias{ResultsVC-class}
%%\alias{betaHat}
%%\alias{betaHat,ResultsVC-method}
%%\alias{betaHat-methods}
%%\alias{betaHatNifti,ResultsVC-method}
%%\alias{hrfHat,ResultsVC-method}
%%\alias{hrfHatPoint,ResultsVC-method}
%%\alias{resetResultsVC,ResultsVC-method}
%%\alias{resetResultsVC}
%%\alias{setResultsVC,ResultsVC-method}
%%\alias{setResultsVC}
\alias{show,ResultsVC-method}
\alias{validResults}
\alias{zeroCoverageNifti}
\alias{zeroCoverageNifti,ResultsVC-method}

\title{Class \code{"ResultsVC"}}
\description{
This is a class which stores results from a varying stimulus coefficient fMRI regression (\code{doFmriVC()}) and further objects needed for postprocessing the results.
}
\section{Objects from the Class}{
Objects are generated by a call to \code{doFmriVC()}. 
If necessary they can be created by calls of the form \code{new("ResultsVC", ...)} or modified by calls to \code{resetResultsVC()}.
}
\section{Slots}{
  \describe{
    \item{\code{VC}:}{Numeric vector with variable values the VC depends on. }
    \item{\code{VC.plot}:}{Vector of VC variable values for which betaHat estimates should be calculated.}    
    \item{\code{nVCknots}:}{Number of knots for the varying coefficient (VC) spline. }
    \item{\code{degreeVCspline}:}{ Degree of the VC spline. }
	\item{\code{stimTimes}:}{Numeric vector with stimulus presentation times of one stimulus type which should have a varying coefficient.}
    \item{\code{nStimBF}:}{Number of canonical HRF basis functions: 1 = just canonical HRF, 2 = plus time derivative, 3 = plus dispersion derivative.}
    \item{\code{U}:}{Design matrix part with nuisance covariables (HPF baseline and confounders). }
    \item{\code{X}:}{Design matrix part with  }
    \item{\code{penMat}:}{Penalty matrix for one VC spline. }
 	\item{\code{total2maskIndex}:}{Object of class \code{"nifti"}, which contains at i,j,k the index of the voxel within the set of selected voxels if selected by mask or zero otherwise.}
    \item{\code{t.plot}:}{Vector of (peristimulus) time values for which hrf estimates should be calculated. }
    \item{alpha}{Significance resp. credibility level. Default: 0.05.}
    \item{\code{method}:}{The method which has been applied for estimation and inference. Either "classical" (penalized least squares) or "bayes". }
    \item{\code{methodResults}:}{A list with estimation results.}
  }
}
\section{Methods}{
	The following methods are dsigned as member functions of this class. Documentation of these functions can be found on separate manual pages.
  \describe{
    \item{betaHat}{\code{signature(object = "ResultsVC")}: ... }
    \item{betaHatNifti}{\code{signature(object = "ResultsVC")}: ... }
    \item{zeroCoverageNifti}{\code{signature(object = "ResultsVC")}: ... }
    \item{hrfHat}{\code{signature(object = "ResultsVC")}: ... }
    \item{hrfHatPoint}{\code{signature(object = "ResultsVC")}: ... }
    \item{resetResultsVC}{\code{signature(object = "ResultsVC")}: ... }
    \item{setResultsVC}{\code{signature(object = "ResultsVC")}: ... }
    \item{show}{\code{signature(object = "ResultsVC")}: ... }
    \item{saveResults}{\code{signature(object = "ResultsVC")}: ... }
	 }
}
\references{
Bothmann, L. (2012). Statistische Modellierung von EEG-abhaengigen Stimuluseffekten in der fMRT-Analyse. Diploma thesis. LMU Munich: Germany. 
}
\author{Ludwig Bothmann and Stefanie Kalus}

\seealso{
	\code{\link{doFmriVC}}, \code{\link{hrfHat}}, \code{\link{betaHat}} \link[=RfmriVC-package]{RfmriVC}\cr\cr  
  Saving and loading an external representation of a ConfigVC-object: \cr 
  \code{\link{saveResults}}, \code{\link{loadResults}}
}

\examples{
showClass("ResultsVC")
}
\keyword{classes}
