\name{BIC of many simple univariate regressions}
\alias{bic.regs}
\title{
BIC of many simple univariate regressions.
}

\description{
BIC of many simple univariate regressions.
}

\usage{
bic.regs(y, x, family = "normal")
}

\arguments{
\item{y}{
The dependent variable, a numerical vector.
}
\item{x}{
A matrix with the indendent variables.
}
\item{family}{
The family of the regression models. "normal", "binomial", "poisson",
"multinomial" or "normlog" (Gaussian regression with log link).
}
}

\details{
Many simple geometric regressions are fitted and the BIC of every model is computed.
}

\value{
A vector with the BIC of each regression model.
}

\author{
Michail Tsagris

R implementation and documentation: Michail Tsagris <mtsagris@yahoo.gr>
}

%\note{
%%  ~~further notes~~
%}

\seealso{
\code{ \link{logistic_only}, \link{poisson_only} }
}

\examples{
y <- rbinom(100, 1, 0.6)
x <- matrix( rnorm(100 * 50), ncol = 50 )
bic.regs(y, x, "binomial")
}

