% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BackendRserve.R
\name{BackendRserve}
\alias{BackendRserve}
\title{Creates Rserve backend for processing HTTP requests}
\description{
Creates BackendRserve object which can start \link{Application} using Rserve backend.
}
\references{
\href{https://github.com/s-u/Rserve/blob/e6b2b6b10e92b6e201d34a05394b2186fda30696/src/http.c#L353-L372}{See http.c in Rserve}
}
\section{Super class}{
\code{\link[RestRserve:Backend]{RestRserve::Backend}} -> \code{BackendRserve}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{BackendRserve$new()}}
\item \href{#method-start}{\code{BackendRserve$start()}}
\item \href{#method-set_request}{\code{BackendRserve$set_request()}}
\item \href{#method-convert_response}{\code{BackendRserve$convert_response()}}
\item \href{#method-clone}{\code{BackendRserve$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates BackendRserve object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BackendRserve$new(..., jit_level = 0L, precompile = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Not used at the moment.}

\item{\code{jit_level}}{changes R's byte compiler level to this value before app
start.}

\item{\code{precompile}}{try to use R's byte compiler to pre-compile}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-start"></a>}}
\if{latex}{\out{\hypertarget{method-start}{}}}
\subsection{Method \code{start()}}{
Starts RestRserve application from current R session.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BackendRserve$start(app, http_port = 8080, ..., background = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{app}}{\link{Application} object.}

\item{\code{http_port}}{HTTP port for application. Negative values (such as -1)
means not to expose plain http.}

\item{\code{...}}{Key-value pairs of the Rserve configuration. If contains
\code{"http.port"} then \code{http_port} will be silently replaced with its value.}

\item{\code{background}}{Whether to try to launch in background process on UNIX.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{ApplicationProcess} object when \code{background = TRUE}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_request"></a>}}
\if{latex}{\out{\hypertarget{method-set_request}{}}}
\subsection{Method \code{set_request()}}{
Parse request and set to it fields.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BackendRserve$set_request(
  request,
  path = "/",
  parameters_query = NULL,
  headers = NULL,
  body = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{request}}{\link{Request} object.}

\item{\code{path}}{Character with requested path. Always starts with \code{/}.}

\item{\code{parameters_query}}{A named character vector with URL decoded query
parameters.}

\item{\code{headers}}{Request HTTP headers.}

\item{\code{body}}{Request body. Can be \code{NULL}, raw vector or named character
vector for the URL encoded form (like a \code{parameters_query} parameter).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{request} modified object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-convert_response"></a>}}
\if{latex}{\out{\hypertarget{method-convert_response}{}}}
\subsection{Method \code{convert_response()}}{
Convert \code{self} object to Rserve compatible structure.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BackendRserve$convert_response(response)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{response}}{\link{Response} object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List with the following structure:
\itemize{
\item \code{body}: can be a character vector of length one or a raw vector.
if the character vector is named "file" then the content of a file of
that name is the body.
If the character vector is named "tmpfile" then the content of a
temporary file of that name is the body.
\item \code{content-type}: must be a character vector of length one or NULL
(if present, else default is \code{"text/plain"}).
\item \code{headers}: must be a character vector - the elements will have CRLF
appended and neither \code{Content-type} nor \code{Content-length} may be used.
\item \code{status-code}: must be an integer if present (default is 200).
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BackendRserve$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
