% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculation.R
\name{pvalue2zs}
\alias{pvalue2zs}
\title{Transfer p-value of KOs to Z-score}
\usage{
pvalue2zs(
  ko_pvalue,
  mode = c("directed", "mixed")[1],
  p.adjust.method1 = "none"
)
}
\arguments{
\item{ko_pvalue}{data.frame from \code{\link{ko.test}}, `KO_id` and `p.value` columns are required.}

\item{mode}{'mixed' or 'directed' (default, only for two groups differential analysis or multi-groups correlation analysis.), see details in \code{\link{pvalue2zs}}.}

\item{p.adjust.method1}{p.adjust.method for `ko.test`, see \code{\link[stats]{p.adjust}}}
}
\value{
ko_stat data.frame
}
\description{
Transfer p-value of KOs to Z-score
}
\details{
'\strong{mixed}' mode is the original reporter-score method from Patil, K. R. et al. PNAS 2005.
In this mode, the reporter score is \strong{undirected}, and the larger the reporter score, the more significant the enrichment, but it cannot indicate the up-and-down regulation information of the pathway! (Liu, L. et al. iMeta 2023.)

steps:

1. Use the Wilcoxon rank sum test to obtain the P value of the significance of each KO difference between the two groups (ie \eqn{P_{koi}}, i represents a certain KO);

2. Using an inverse normal distribution, convert the P value of each KO into a Z value (\eqn{Z_{koi}}), the formula:

\eqn{Z_{koi}=\theta ^{-1}(1-P_{koi})}

3. 'Upgrade' KO to pathway: \eqn{Z_{koi}}, calculate the Z value of the pathway, the formula:

\eqn{Z_{pathway}=\frac{1}{\sqrt{k}}\sum Z_{koi}}

where k means A total of k KOs were annotated to the corresponding pathway;

4. Evaluate the degree of significance: permutation (permutation) 1000 times, get the random distribution of \eqn{Z_{pathway}}, the formula:

\eqn{Z_{adjustedpathway}=(Z_{pathway}-\mu _k)/\sigma _k}

\eqn{\mu _k} is The mean of the random distribution, \eqn{\sigma _k} is the standard deviation of the random distribution.

Instead, '\strong{directed}' mode is a derived version of 'mixed', referenced from \code{https://github.com/wangpeng407/ReporterScore}.

This approach is based on the same assumption of many differential analysis methods: the expression of most genes has no significant change.

steps:

1. Use the Wilcoxon rank sum test to obtain the P value of the significance of each KO difference between the two groups (ie \eqn{P_{koi}}, i represents a certain KO), and then divide the P value by 2, that is, the range of (0,1] becomes (0,0.5], \eqn{P_{koi}=P_{koi}/2};

2. Using an inverse normal distribution, convert the P value of each KO into a Z value (\eqn{Z_{koi}}), the formula:

\eqn{Z_{koi}=\theta ^{-1}(1-P_{koi})}

since the above P value is less than 0.5, all Z values will be greater than 0;

3. Considering whether each KO is up-regulated or down-regulated, calculate \eqn{diff\_KO},

\eqn{Z_{koi}=-Z_{koi}\ \ \ \ (diff\_KO<0)},

so \eqn{Z_{koi}} is greater than 0 Up-regulation, \eqn{Z_{koi}} less than 0 is down-regulation;

4. 'Upgrade' KO to pathway: \eqn{Z_{koi}}, calculate the Z value of the pathway, the formula:

 \eqn{Z_{pathway}=\frac{1}{\sqrt{k}}\sum Z_{koi}}

 where k means A total of k KOs were annotated to the corresponding pathway;

5. Evaluate the degree of significance: permutation (permutation) 1000 times, get the random distribution of \eqn{Z_{pathway}}, the formula:

\eqn{Z_{adjustedpathway}=(Z_{pathway}-\mu _k)/\sigma _k}

\eqn{\mu _k} is The mean of the random distribution, \eqn{\sigma _k} is the standard deviation of the random distribution.

The finally obtained \eqn{Z_{adjustedpathway}} is the Reporter score value enriched for each pathway.
In this mode, the Reporter score is directed, and a larger positive value represents a significant up-regulation enrichment, and a smaller negative values represent significant down-regulation enrichment.

However, the disadvantage of this mode is that when a pathway contains about the same number of significantly up-regulates KOs and significantly down-regulates KOs, the final absolute value of Reporter score may approach 0, becoming a pathway that has not been significantly enriched.
}
\examples{
\donttest{
data("KO_abundance_test")
ko_pvalue <- ko.test(KO_abundance, "Group", metadata)
ko_stat <- pvalue2zs(ko_pvalue, mode = "directed")
}
}
\references{
1. Patil, K. R. & Nielsen, J. Uncovering transcriptional regulation of metabolism by using metabolic network topology. Proc Natl Acad Sci U S A 102, 2685–2689 (2005).
2. Liu, L., Zhu, R. & Wu, D. Misuse of reporter score in microbial enrichment analysis. iMeta n/a, e95.
3. \code{https://github.com/wangpeng407/ReporterScore}
}
\seealso{
Other GRSA: 
\code{\link{combine_rs_res}()},
\code{\link{get_reporter_score}()},
\code{\link{ko.test}()},
\code{\link{reporter_score}()}
}
\concept{GRSA}
