% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculation.R
\name{ko.test}
\alias{ko.test}
\title{Differential analysis or Correlation analysis for KO-abundance table}
\usage{
ko.test(
  kodf,
  group,
  metadata = NULL,
  method = "wilcox.test",
  pattern = NULL,
  p.adjust.method1 = "none",
  threads = 1,
  verbose = TRUE
)
}
\arguments{
\item{kodf}{KO_abundance table, rowname is ko id (e.g. K00001), colnames is samples}

\item{group}{The comparison groups (at least two categories) in your data, one column name of metadata when metadata exist or a vector whose length equal to columns number of kodf. And you can use factor levels to change order.}

\item{metadata}{sample information data.frame contains group}

\item{method}{the method of test. Default is `wilcox.test`. Allowed values include:
\itemize{
\item \code{\link[stats]{t.test}} (parametric) and \code{\link[stats]{wilcox.test}} (non-parametric). Perform comparison between two groups of samples. If the grouping variable contains more than two levels, then a pairwise comparison is performed.
\item \code{\link[stats]{anova}} (parametric) and \code{\link[stats]{kruskal.test}} (non-parametric). Perform one-way ANOVA test comparing multiple groups.
\item 'pearson', 'kendall', or 'spearman' (correlation), see \code{\link[stats]{cor}}.}}

\item{pattern}{a named vector matching the group, e.g. c('G1'=1,'G2'=3,'G3'=2), use the correlation analysis with specific pattern to calculate p-value.}

\item{p.adjust.method1}{p.adjust.method, see \code{\link[stats]{p.adjust}}}

\item{threads}{default 1}

\item{verbose}{logical}
}
\value{
ko_pvalue data.frame
}
\description{
Differential analysis or Correlation analysis for KO-abundance table
}
\examples{
\donttest{
data("KO_abundance_test")
ko_pvalue <- ko.test(KO_abundance, "Group", metadata)
}
}
