% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichment.R
\name{KO_enrich}
\alias{KO_enrich}
\alias{KO_fisher}
\alias{as.enrich_res}
\alias{KO_gsea}
\title{Perform enrichment analysis}
\usage{
KO_enrich(
  ko_stat,
  padj_threshold = 0.05,
  logFC_threshold = NULL,
  add_mini = NULL,
  p.adjust.method = "BH",
  type = c("pathway", "module")[1],
  feature = "ko",
  modulelist = NULL,
  verbose = TRUE
)

KO_fisher(
  ko_stat,
  padj_threshold = 0.05,
  logFC_threshold = NULL,
  add_mini = NULL,
  p.adjust.method = "BH",
  type = c("pathway", "module")[1],
  feature = "ko",
  modulelist = NULL,
  verbose = TRUE
)

as.enrich_res(gsea_res)

KO_gsea(
  ko_stat,
  weight = "logFC",
  add_mini = NULL,
  padj_threshold = 1,
  p.adjust.method = "BH",
  type = c("pathway", "module")[1],
  feature = "ko",
  modulelist = NULL,
  verbose = TRUE
)
}
\arguments{
\item{ko_stat}{ko_stat dataframe from \code{\link[ReporterScore]{ko.test}}.}

\item{padj_threshold}{p.adjust threshold to determine whether a feature significant or not. p.adjust < padj_threshold, default: 0.05}

\item{logFC_threshold}{logFC threshold to determine whether a feature significant or not. abs(logFC)>logFC_threshold, default: NULL}

\item{add_mini}{add_mini when calculate the logFC. e.g (10+0.1)/(0+0.1), default 0.05*min(avg_abundance)}

\item{p.adjust.method}{The method used for p-value adjustment (default: "BH").}

\item{type}{"pathway" or "module" for default KOlist_file.}

\item{feature}{one of "ko", "gene", "compound"}

\item{modulelist}{NULL or customized modulelist dataframe, must contain "id","K_num","KOs","Description" columns. Take the `KOlist` as example, use \code{\link{custom_modulelist}}.}

\item{verbose}{logical}

\item{gsea_res}{gsea_res from KO_gsea}

\item{weight}{the metric used for ranking, default: logFC}
}
\value{
A data frame containing the enrichment results.

data.frame

enrich_res object
}
\description{
This function performs KO enrichment analysis using the `clusterProfiler` package.
}
\examples{
## use `enricher` from the `clusterProfiler` package.
data("reporter_score_res")
enrich_res <- KO_enrich(reporter_score_res)
plot(enrich_res)
## use `fisher.test` from the `stats` package.
fisher_res <- KO_fisher(reporter_score_res)
message("The following example require some time to run:")
\donttest{
## use `GSEA` from the `clusterProfiler` package.
gsea_res <- KO_gsea(reporter_score_res, p.adjust.method = "none")
enrichplot::gseaplot(gsea_res, geneSetID = data.frame(gsea_res)$ID[1])
gsea_res_df <- as.enrich_res(gsea_res)
plot(gsea_res_df)
}
}
