/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.DrawingML;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import org.docx4j.XmlUtils;
import org.docx4j.dml.CTBlip;
import org.docx4j.dml.CTRegularTextRun;
import org.docx4j.dml.CTTextBody;
import org.docx4j.dml.CTTextParagraph;
import org.docx4j.dml.diagram.CTCxn;
import org.docx4j.dml.diagram.CTCxnList;
import org.docx4j.dml.diagram.CTDataModel;
import org.docx4j.dml.diagram.CTElemPropSet;
import org.docx4j.dml.diagram.CTPt;
import org.docx4j.dml.diagram.CTPtList;
import org.docx4j.dml.diagram.STPtType;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.parts.DrawingML.DiagramDataPart;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage;
import org.opendope.SmartArt.dataHierarchy.ImageRef;
import org.opendope.SmartArt.dataHierarchy.ListItem;
import org.opendope.SmartArt.dataHierarchy.ObjectFactory;
import org.opendope.SmartArt.dataHierarchy.SibTransBody;
import org.opendope.SmartArt.dataHierarchy.SmartArtDataHierarchy;
import org.opendope.SmartArt.dataHierarchy.TextBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramDataUnflatten {
    private static Logger log = LoggerFactory.getLogger(DiagramDataUnflatten.class);
    protected static String PRESNAME_FOR_IMAGE = "image";
    private org.docx4j.dml.ObjectFactory dmlFactory;
    private org.docx4j.dml.diagram.ObjectFactory diagramFactory;
    private DiagramDataPart diagramDataPart;
    private CTPtList ptList;
    private CTCxnList cxnList;
    private ObjectFactory factory;
    private SmartArtDataHierarchy.Texts texts;
    private SmartArtDataHierarchy.Images images;
    private List<JAXBElement<CTTextBody>> textFormats;

    public DiagramDataUnflatten(DiagramDataPart diagramDataPart) {
        this.diagramDataPart = diagramDataPart;
        this.ptList = ((CTDataModel)diagramDataPart.getJaxbElement()).getPtLst();
        this.cxnList = ((CTDataModel)diagramDataPart.getJaxbElement()).getCxnLst();
        this.factory = new ObjectFactory();
        this.texts = this.factory.createSmartArtDataHierarchyTexts();
        this.images = this.factory.createSmartArtDataHierarchyImages();
        this.textFormats = new ArrayList<JAXBElement<CTTextBody>>();
        this.dmlFactory = new org.docx4j.dml.ObjectFactory();
        this.diagramFactory = new org.docx4j.dml.diagram.ObjectFactory();
    }

    public ObjectFactory getDataHierarchyObjectFactory() {
        return this.factory;
    }

    public SmartArtDataHierarchy.Texts getTexts() {
        return this.texts;
    }

    public List<JAXBElement<CTTextBody>> getTextFormats() {
        return this.textFormats;
    }

    public SmartArtDataHierarchy convert() {
        SmartArtDataHierarchy smartArtDataHierarchy = this.factory.createSmartArtDataHierarchy();
        CTPt docPt = this.ptList.getPt().get(0);
        if (docPt.getPrSet() != null && docPt.getPrSet().getLoTypeId() != null) {
            smartArtDataHierarchy.setLoTypeId(docPt.getPrSet().getLoTypeId());
        } else {
            log.error("Couldn't read @loTypeId");
        }
        org.opendope.SmartArt.dataHierarchy.List docList = this.factory.createList();
        ListItem listItem = this.factory.createListItem();
        docList.getListItem().add(listItem);
        listItem.setId(docPt.getModelId());
        listItem.setDepth(0);
        this.processChildrenOf(docPt, listItem);
        smartArtDataHierarchy.setList(docList);
        smartArtDataHierarchy.setImages(this.images);
        smartArtDataHierarchy.setTexts(this.texts);
        return smartArtDataHierarchy;
    }

    public CTTextBody processText(ListItem thisListItem, CTPt thisPoint) {
        CTTextBody textBody = thisPoint.getT();
        if (textBody != null) {
            TextBody tb = this.getDataHierarchyObjectFactory().createTextBody();
            thisListItem.setTextBody(tb);
            for (CTTextParagraph p : textBody.getP()) {
                if (p.getEGTextRun().isEmpty() || !(p.getEGTextRun().get(0) instanceof CTRegularTextRun)) continue;
                CTRegularTextRun run = (CTRegularTextRun)p.getEGTextRun().get(0);
                tb.getP().add(run.getT());
            }
        }
        return textBody;
    }

    private void processChildrenOf(CTPt pt, ListItem listItem) {
        List<ListItem> childModelIds = this.createListItemsForChildren(pt);
        if (childModelIds.isEmpty()) {
            return;
        }
        org.opendope.SmartArt.dataHierarchy.List list = this.factory.createList();
        listItem.setList(list);
        for (ListItem thisListItem : childModelIds) {
            CTPt sibTrans;
            CTPt imgPt;
            list.getListItem().add(thisListItem);
            thisListItem.setDepth(listItem.getDepth() + 1);
            String modelId = thisListItem.getId();
            CTPt thisPoint = this.getPoint(modelId);
            CTTextBody textBody = this.processText(thisListItem, thisPoint);
            if (this.textFormats.size() < thisListItem.getDepth()) {
                if (textBody == null) {
                    this.textFormats.add(this.diagramFactory.createT(this.dmlFactory.createCTTextBody()));
                } else {
                    this.textFormats.add(this.diagramFactory.createT(textBody));
                }
            }
            if ((imgPt = this.getAssociatedPres(modelId, PRESNAME_FOR_IMAGE)) != null && imgPt.getSpPr() != null && imgPt.getSpPr().getBlipFill() != null && imgPt.getSpPr().getBlipFill().getBlip() != null) {
                CTBlip blip = imgPt.getSpPr().getBlipFill().getBlip();
                if (blip.getEmbed() != null) {
                    String relId = blip.getEmbed();
                    BinaryPartAbstractImage bpai = (BinaryPartAbstractImage)this.diagramDataPart.getRelationshipsPart().getPart(relId);
                    SmartArtDataHierarchy.Images.Image image = this.factory.createSmartArtDataHierarchyImagesImage();
                    image.setContentType(bpai.getContentType());
                    image.setId(imgPt.getModelId());
                    image.setValue(bpai.getBytes());
                    this.images.getImage().add(image);
                    ImageRef imageRef = this.factory.createImageRef();
                    imageRef.setContentRef(imgPt.getModelId());
                    if (imgPt.getPrSet() != null) {
                        CTElemPropSet props = imgPt.getPrSet();
                        if (props.getCustLinFactNeighborX() != null) {
                            imageRef.setCustLinFactNeighborX(props.getCustLinFactNeighborX());
                        }
                        if (props.getCustLinFactNeighborY() != null) {
                            imageRef.setCustLinFactNeighborY(props.getCustLinFactNeighborY());
                        }
                        if (props.getCustScaleX() != null) {
                            imageRef.setCustScaleX(props.getCustScaleX());
                        }
                        if (props.getCustScaleY() != null) {
                            imageRef.setCustScaleY(props.getCustScaleY());
                        }
                    }
                    thisListItem.setImageRef(imageRef);
                } else if (blip.getLink() != null) {
                    // empty if block
                }
            }
            if ((sibTrans = this.getPoint(thisListItem.getSibTransBody().getContentRef())).getT() != null && sibTrans.getT().getP() != null && sibTrans.getT().getP().get(0) != null && sibTrans.getT().getP().get(0).getEGTextRun() != null && !sibTrans.getT().getP().get(0).getEGTextRun().isEmpty()) {
                SmartArtDataHierarchy.Texts.IdentifiedText wrapper = this.factory.createSmartArtDataHierarchyTextsIdentifiedText();
                wrapper.setId(sibTrans.getModelId());
                wrapper.setT(sibTrans.getT());
                this.texts.getIdentifiedText().add(wrapper);
            } else {
                thisListItem.setSibTransBody(null);
            }
            this.processChildrenOf(thisPoint, thisListItem);
        }
    }

    public CTPt getPoint(String modelId) {
        for (CTPt pt : this.ptList.getPt()) {
            if (!pt.getModelId().equals(modelId)) continue;
            return pt;
        }
        return null;
    }

    public CTPt getAssociatedPres(String modelId, String presNamePrefix) {
        for (CTPt pt : this.ptList.getPt()) {
            if (!pt.getType().equals((Object)STPtType.PRES) || pt.getPrSet() == null || pt.getPrSet().getPresName() == null || !pt.getPrSet().getPresName().startsWith(presNamePrefix) || !pt.getPrSet().getPresAssocID().equals(modelId)) continue;
            return pt;
        }
        return null;
    }

    public List<ListItem> createListItemsForChildren(CTPt parent) {
        ArrayList<ListItem> childListItemList = new ArrayList<ListItem>();
        String parentId = parent.getModelId();
        for (CTCxn cxn : this.cxnList.getCxn()) {
            if (!cxn.getSrcId().equals(parentId) || cxn.getSibTransId().equals("0")) continue;
            ListItem thisListItem = this.factory.createListItem();
            thisListItem.setId(cxn.getDestId());
            SibTransBody sibTransBody = this.factory.createSibTransBody();
            sibTransBody.setContentRef(cxn.getSibTransId());
            thisListItem.setSibTransBody(sibTransBody);
            childListItemList.add(thisListItem);
        }
        return childListItemList;
    }

    public static void main(String[] args) throws Exception {
        OpcPackage pkg = OpcPackage.load(new File(System.getProperty("user.dir") + "/sample-docs/glox/extracted/apes.pptx"));
        JaxbXmlPart thisPart = null;
        for (Map.Entry<PartName, Part> entry : pkg.getParts().getParts().entrySet()) {
            if (!entry.getValue().getContentType().equals("application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml")) continue;
            thisPart = (DiagramDataPart)entry.getValue();
            break;
        }
        if (thisPart == null) {
            System.out.println("No SmartArt found in this docx.");
            return;
        }
        DiagramDataPart.setFriendlyIds(thisPart.getJaxbElement());
        DiagramDataUnflatten diagramDataUnflatten = new DiagramDataUnflatten((DiagramDataPart)thisPart);
        String exchange = XmlUtils.marshaltoString((Object)diagramDataUnflatten.convert(), true, true);
        System.out.println(exchange);
    }
}

