/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilder;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.FOSettings;
import org.docx4j.convert.out.HTMLSettings;
import org.docx4j.convert.out.common.Exporter;
import org.docx4j.convert.out.common.preprocess.PartialDeepCopy;
import org.docx4j.convert.out.flatOpcXml.FlatOpcXmlCreator;
import org.docx4j.convert.out.fo.FOExporterVisitor;
import org.docx4j.convert.out.fo.FOExporterXslt;
import org.docx4j.convert.out.html.HTMLExporterVisitor;
import org.docx4j.convert.out.html.HTMLExporterXslt;
import org.docx4j.customXmlProperties.DatastoreItem;
import org.docx4j.customXmlProperties.SchemaRefs;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.NamespacePrefixMapperUtils;
import org.docx4j.model.datastorage.BindingHandler;
import org.docx4j.model.datastorage.OpenDoPEHandler;
import org.docx4j.model.datastorage.RemovalHandler;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.io.SaveToZipFile;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePart;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePropertiesPart;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.utils.TraversalUtilVisitor;
import org.docx4j.wml.SdtElement;
import org.docx4j.wml.SdtPr;
import org.docx4j.xmlPackage.Package;
import org.opendope.xpaths.Xpaths;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Docx4J {
    public static final String MIME_PDF = "application/pdf";
    public static final String MIME_FO = "application/xml-fo";
    public static final int FLAG_NONE = 0;
    public static final int FLAG_EXPORT_PREFER_XSL = 1;
    public static final int FLAG_EXPORT_PREFER_NONXSL = 2;
    public static final int FLAG_SAVE_ZIP_FILE = 1;
    public static final int FLAG_SAVE_FLAT_XML = 2;
    public static final int FLAG_BIND_INSERT_XML = 1;
    public static final int FLAG_BIND_BIND_XML = 2;
    public static final int FLAG_BIND_REMOVE_SDT = 4;
    public static final int FLAG_BIND_REMOVE_XML = 8;
    protected static final String NS_CONDITIONS = "http://opendope.org/conditions";
    protected static final String NS_XPATHS = "http://opendope.org/xpaths";
    protected static final String NS_QUESTIONS = "http://opendope.org/questions";
    protected static final String NS_COMPONENTS = "http://opendope.org/components";
    protected static final Set<String> PART_TO_REMOVE_SCHEMA_TYPES = new TreeSet<String>();

    public static WordprocessingMLPackage load(File inFile) throws Docx4JException {
        return WordprocessingMLPackage.load(inFile);
    }

    public static WordprocessingMLPackage load(InputStream inStream) throws Docx4JException {
        return WordprocessingMLPackage.load(inStream);
    }

    public static void save(WordprocessingMLPackage wmlPackage, File outFile, int flags) throws Docx4JException {
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(outFile);
            Docx4J.save(wmlPackage, outStream, flags);
        }
        catch (FileNotFoundException e) {
            throw new Docx4JException("Exception creating output stream: " + e.getMessage(), e);
        }
        finally {
            if (outStream != null) {
                try {
                    ((OutputStream)outStream).close();
                }
                catch (IOException e) {}
                outStream = null;
            }
        }
    }

    public static void save(WordprocessingMLPackage wmlPackage, OutputStream outStream, int flags) throws Docx4JException {
        if (flags == 2) {
            JAXBContext jc = Context.jcXmlPackage;
            FlatOpcXmlCreator opcXmlCreator = new FlatOpcXmlCreator(wmlPackage);
            Package pkg = opcXmlCreator.get();
            try {
                Marshaller marshaller = jc.createMarshaller();
                NamespacePrefixMapperUtils.setProperty(marshaller, NamespacePrefixMapperUtils.getPrefixMapper());
                marshaller.marshal((Object)pkg, outStream);
            }
            catch (JAXBException e) {
                throw new Docx4JException("Exception marshalling document for output: " + e.getMessage(), (Exception)((Object)e));
            }
        } else {
            SaveToZipFile saver = new SaveToZipFile(wmlPackage);
            saver.save(outStream);
        }
    }

    public static void bind(WordprocessingMLPackage wmlPackage, String xmlDocument, int flags) throws Docx4JException {
        ByteArrayInputStream xmlStream = null;
        if (flags == 0) {
            flags = 15;
        }
        if ((flags & 1) == 1) {
            try {
                xmlStream = new ByteArrayInputStream(xmlDocument.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e1) {
                xmlStream = new ByteArrayInputStream(xmlDocument.getBytes());
            }
        }
        Docx4J.bind(wmlPackage, xmlStream, flags);
    }

    public static void bind(WordprocessingMLPackage wmlPackage, InputStream xmlDocument, int flags) throws Docx4JException {
        if (flags == 0) {
            flags = 15;
        }
        Document xmlDoc = null;
        if ((flags & 1) == 1) {
            DocumentBuilder documentBuilder = null;
            try {
                documentBuilder = XmlUtils.getDocumentBuilderFactory().newDocumentBuilder();
                xmlDoc = documentBuilder.parse(xmlDocument);
            }
            catch (Exception e) {
                throw new Docx4JException("Problems creating a org.w3c.dom.Document for the passed input stream.", e);
            }
        }
        Docx4J.bind(wmlPackage, xmlDoc, flags);
    }

    public static void bind(WordprocessingMLPackage wmlPackage, Document xmlDocument, int flags) throws Docx4JException {
        OpenDoPEHandler openDoPEHandler = null;
        Object customXmlDataStoragePart = null;
        Object removalHandler = null;
        String xpathStorageItemId = null;
        if (flags == 0) {
            flags = 15;
        }
        if ((xpathStorageItemId = Docx4J.findXPathStorageItemIdInXPathsPart(wmlPackage)) == null && flags == 1) {
            xpathStorageItemId = Docx4J.findXPathStorageItemIdInContentControls(wmlPackage);
        }
        if (xpathStorageItemId == null) {
            throw new Docx4JException("No xpathStorageItemId found, does the document contain content controls that are bound?");
        }
        if ((flags & 1) == 1) {
            Docx4J.insertXMLData(wmlPackage, xpathStorageItemId, xmlDocument);
        }
        if ((flags & 2) == 2) {
            openDoPEHandler = new OpenDoPEHandler(wmlPackage);
            openDoPEHandler.preprocess();
            BindingHandler.applyBindings(wmlPackage);
        }
        if ((flags & 4) == 4) {
            Docx4J.removeSDTs(wmlPackage);
        }
        if ((flags & 8) == 8) {
            Docx4J.removeDefinedCustomXmlParts(wmlPackage, xpathStorageItemId);
        }
    }

    protected static void insertXMLData(WordprocessingMLPackage wmlPackage, String storageId, Document xmlDocument) throws Docx4JException {
        Object customXmlDataStorage = null;
        CustomXmlDataStoragePart customXmlDataStoragePart = null;
        customXmlDataStoragePart = (CustomXmlDataStoragePart)wmlPackage.getCustomXmlDataStorageParts().get(storageId.toLowerCase());
        customXmlDataStoragePart.getData().setDocument(xmlDocument);
    }

    protected static String findXPathStorageItemIdInXPathsPart(WordprocessingMLPackage wmlPackage) {
        String ret = null;
        List<Xpaths.Xpath> xpathList = null;
        Xpaths.Xpath xpath = null;
        try {
            if (wmlPackage.getMainDocumentPart().getXPathsPart() != null && wmlPackage.getMainDocumentPart().getXPathsPart().getJaxbElement() != null && ((Xpaths)wmlPackage.getMainDocumentPart().getXPathsPart().getJaxbElement()).getXpath() != null) {
                xpathList = ((Xpaths)wmlPackage.getMainDocumentPart().getXPathsPart().getJaxbElement()).getXpath();
            }
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        if (xpathList != null && xpathList.size() > 0) {
            for (int i = 0; ret == null && i < xpathList.size(); ++i) {
                xpath = (Xpaths.Xpath)xpathList.get(i);
                if (xpath.getDataBinding() == null) continue;
                ret = xpath.getDataBinding().getStoreItemID();
            }
        }
        return ret;
    }

    protected static String findXPathStorageItemIdInContentControls(WordprocessingMLPackage wmlPackage) {
        FindContentControlsVisitor visitor = null;
        if (wmlPackage.getCustomXmlDataStorageParts() != null && !wmlPackage.getCustomXmlDataStorageParts().isEmpty()) {
            try {
                visitor = new FindContentControlsVisitor(wmlPackage.getCustomXmlDataStorageParts().keySet());
                TraversalUtil.visit(wmlPackage, false, visitor);
            }
            catch (FindContentControlsVisitor.BreakException breakException) {
                // empty catch block
            }
        }
        return visitor != null ? visitor.getdefinedStoreItemId() : null;
    }

    protected static void removeSDTs(WordprocessingMLPackage wmlPackage) throws Docx4JException {
        RemovalHandler removalHandler = new RemovalHandler();
        removalHandler.removeSDTs(wmlPackage.getMainDocumentPart(), RemovalHandler.Quantifier.ALL, (String[])null);
        for (Part part : wmlPackage.getParts().getParts().values()) {
            if (part instanceof HeaderPart) {
                removalHandler.removeSDTs((HeaderPart)part, RemovalHandler.Quantifier.ALL, (String[])null);
                continue;
            }
            if (!(part instanceof FooterPart)) continue;
            removalHandler.removeSDTs((FooterPart)part, RemovalHandler.Quantifier.ALL, (String[])null);
        }
    }

    protected static void removeDefinedCustomXmlParts(WordprocessingMLPackage wmlPackage, String xpathStorageItemId) {
        ArrayList<PartName> partsToRemove = new ArrayList<PartName>();
        RelationshipsPart relationshipsPart = wmlPackage.getMainDocumentPart().getRelationshipsPart();
        List<Relationship> relationshipsList = relationshipsPart != null && relationshipsPart.getRelationships() != null ? relationshipsPart.getRelationships().getRelationship() : null;
        Part part = null;
        Object dataPart = null;
        if (relationshipsList != null) {
            for (Relationship relationship : relationshipsList) {
                if (!"http://schemas.openxmlformats.org/officeDocument/2006/relationships/customXml".equals(relationship.getType()) || !Docx4J.IsPartToRemove(part = relationshipsPart.getPart(relationship), xpathStorageItemId)) continue;
                partsToRemove.add(part.getPartName());
            }
        }
        if (!partsToRemove.isEmpty()) {
            for (int i = 0; i < partsToRemove.size(); ++i) {
                relationshipsPart.removePart((PartName)partsToRemove.get(i));
            }
        }
    }

    protected static boolean IsPartToRemove(Part part, String xpathStorageItemId) {
        boolean ret = false;
        RelationshipsPart relationshipsPart = part.getRelationshipsPart();
        List<Relationship> relationshipsList = relationshipsPart != null && relationshipsPart.getRelationships() != null ? relationshipsPart.getRelationships().getRelationship() : null;
        JaxbXmlPart propertiesPart = null;
        DatastoreItem datastoreItem = null;
        if (relationshipsList != null && !relationshipsList.isEmpty()) {
            for (Relationship relationship : relationshipsList) {
                if (!"http://schemas.openxmlformats.org/officeDocument/2006/relationships/customXmlProps".equals(relationship.getType())) continue;
                propertiesPart = (CustomXmlDataStoragePropertiesPart)relationshipsPart.getPart(relationship);
                break;
            }
        }
        if (propertiesPart != null) {
            datastoreItem = (DatastoreItem)propertiesPart.getJaxbElement();
        }
        if (datastoreItem != null) {
            if (datastoreItem.getItemID() != null && datastoreItem.getItemID().length() > 0) {
                ret = datastoreItem.getItemID().equals(xpathStorageItemId);
            }
            if (!ret && datastoreItem.getSchemaRefs() != null && datastoreItem.getSchemaRefs().getSchemaRef() != null && !datastoreItem.getSchemaRefs().getSchemaRef().isEmpty()) {
                for (SchemaRefs.SchemaRef ref : datastoreItem.getSchemaRefs().getSchemaRef()) {
                    if (!PART_TO_REMOVE_SCHEMA_TYPES.contains(ref.getUri())) continue;
                    ret = true;
                    break;
                }
            }
        }
        return ret;
    }

    public static WordprocessingMLPackage clone(WordprocessingMLPackage wmlPackage) throws Docx4JException {
        return (WordprocessingMLPackage)PartialDeepCopy.process(wmlPackage, null);
    }

    public static FOSettings createFOSettings() {
        return new FOSettings();
    }

    public static void toFO(FOSettings settings, OutputStream outputStream, int flags) throws Docx4JException {
        Exporter<FOSettings> exporter = Docx4J.getFOExporter(flags);
        exporter.export(settings, outputStream);
    }

    public static void toPDF(WordprocessingMLPackage wmlPackage, OutputStream outputStream) throws Docx4JException {
        FOSettings settings = Docx4J.createFOSettings();
        settings.setWmlPackage(wmlPackage);
        settings.setApacheFopMime(MIME_PDF);
        Docx4J.toFO(settings, outputStream, 0);
    }

    protected static Exporter<FOSettings> getFOExporter(int flags) {
        switch (flags) {
            case 2: {
                return FOExporterVisitor.getInstance();
            }
        }
        return FOExporterXslt.getInstance();
    }

    public static HTMLSettings createHTMLSettings() {
        return new HTMLSettings();
    }

    public static void toHTML(HTMLSettings settings, OutputStream outputStream, int flags) throws Docx4JException {
        Exporter<HTMLSettings> exporter = Docx4J.getHTMLExporter(flags);
        exporter.export(settings, outputStream);
    }

    public static void toHTML(WordprocessingMLPackage wmlPackage, String imageDirPath, String imageTargetUri, OutputStream outputStream) throws Docx4JException {
        HTMLSettings settings = Docx4J.createHTMLSettings();
        settings.setWmlPackage(wmlPackage);
        if (imageDirPath != null) {
            settings.setImageDirPath(imageDirPath);
        }
        if (imageTargetUri != null) {
            settings.setImageTargetUri(imageTargetUri);
        }
        Docx4J.toHTML(settings, outputStream, 0);
    }

    protected static Exporter<HTMLSettings> getHTMLExporter(int flags) {
        switch (flags) {
            case 2: {
                return HTMLExporterVisitor.getInstance();
            }
        }
        return HTMLExporterXslt.getInstance();
    }

    static {
        PART_TO_REMOVE_SCHEMA_TYPES.add(NS_CONDITIONS);
        PART_TO_REMOVE_SCHEMA_TYPES.add(NS_XPATHS);
        PART_TO_REMOVE_SCHEMA_TYPES.add(NS_QUESTIONS);
        PART_TO_REMOVE_SCHEMA_TYPES.add(NS_COMPONENTS);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class FindContentControlsVisitor
    extends TraversalUtilVisitor<SdtElement> {
        protected Set<String> definedStoreItemIds = null;
        protected String storeItemId = null;

        public FindContentControlsVisitor(Set<String> definedStoreItemIds) {
            this.definedStoreItemIds = definedStoreItemIds;
        }

        @Override
        public void apply(SdtElement element) {
            String tmp;
            SdtPr sdtPr = element.getSdtPr();
            if (sdtPr.getDataBinding() != null && sdtPr.getDataBinding().getStoreItemID() != null && this.definedStoreItemIds.contains(tmp = sdtPr.getDataBinding().getStoreItemID().toLowerCase())) {
                this.storeItemId = tmp;
                throw new BreakException();
            }
        }

        public String getdefinedStoreItemId() {
            return this.storeItemId;
        }

        public static class BreakException
        extends RuntimeException {
        }
    }
}

