/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx;

import com.topologi.diffx.DiffXException;
import com.topologi.diffx.algorithm.GuanoAlgorithm;
import com.topologi.diffx.config.DiffXConfig;
import com.topologi.diffx.config.TextGranularity;
import com.topologi.diffx.config.WhiteSpaceProcessing;
import com.topologi.diffx.format.SafeXMLFormatter;
import com.topologi.diffx.load.DOMRecorder;
import com.topologi.diffx.sequence.EventSequence;
import com.topologi.diffx.sequence.SequenceSlicer;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class Extension {
    private static final Map<String, String> BUILDERS = new Hashtable<String, String>();

    public static Node diff(Node xml1, Node xml2, String whitespace, String granularity) throws DiffXException, IOException {
        DiffXConfig config = Extension.toConfig(whitespace, granularity);
        DOMRecorder loader = new DOMRecorder();
        loader.setConfig(config);
        EventSequence seq1 = loader.process(xml1);
        EventSequence seq2 = loader.process(xml2);
        if (seq1.size() == 0 && seq1.size() == 0) {
            return null;
        }
        StringWriter out = new StringWriter();
        Extension.diff(seq1, seq2, out, config);
        try {
            String factory = Extension.getFactoryClass(xml1, xml2);
            Node node = Extension.toNode(out.toString(), config, factory);
            return node;
        }
        catch (Exception ex) {
            throw new DiffXException("Could not generate Node from Diff-X result", ex);
        }
    }

    private static void diff(EventSequence seq1, EventSequence seq2, Writer out, DiffXConfig config) throws DiffXException, IOException {
        SafeXMLFormatter formatter = new SafeXMLFormatter(out);
        formatter.declarePrefixMapping(seq1.getPrefixMapping());
        formatter.declarePrefixMapping(seq2.getPrefixMapping());
        if (config != null) {
            formatter.setConfig(config);
        }
        SequenceSlicer slicer = new SequenceSlicer(seq1, seq2);
        slicer.slice();
        slicer.formatStart(formatter);
        GuanoAlgorithm df = new GuanoAlgorithm(seq1, seq2);
        df.process(formatter);
        slicer.formatEnd(formatter);
    }

    private static DiffXConfig toConfig(String whitespace, String granularity) {
        WhiteSpaceProcessing ws = WhiteSpaceProcessing.valueOf(whitespace);
        TextGranularity tg = TextGranularity.valueOf(granularity);
        return new DiffXConfig(ws, tg);
    }

    private static Node toNode(String xml, DiffXConfig config, String factory) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setNamespaceAware(config.isNamespaceAware());
        dbFactory.setExpandEntityReferences(true);
        dbFactory.setValidating(false);
        DocumentBuilder builder = dbFactory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(xml)));
        return document.getDocumentElement();
    }

    private static String getFactoryClass(Node xml1, Node xml2) {
        Package pkg = xml1 != null ? xml1.getClass().getPackage() : (xml2 != null ? xml2.getClass().getPackage() : null);
        return BUILDERS.get(pkg.getName());
    }

    static {
        BUILDERS.put("net.sf.saxon.dom", "net.sf.saxon.dom.DocumentBuilderFactoryImpl");
    }
}

