% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parProperties.R
\name{parProperties}
\alias{chprop.parProperties}
\alias{parProperties}
\alias{print.parProperties}
\title{Paragraph formatting properties}
\usage{
parProperties(text.align = "left", padding.bottom = 1, padding.top = 1,
  padding.left = 1, padding.right = 1, padding, list.style = "none",
  level = 1, border.bottom = borderNone(), border.left = borderNone(),
  border.top = borderNone(), border.right = borderNone(), shading.color)

\method{chprop}{parProperties}(object, text.align, padding.bottom, padding.top,
  padding.left, padding.right, padding, list.style, level, border.bottom,
  border.left, border.top, border.right, shading.color, ...)

\method{print}{parProperties}(x, ...)
}
\arguments{
\item{text.align}{text alignment - a single character value, expected value
is one of 'left', 'right', 'center', 'justify'.}

\item{padding.bottom}{paragraph bottom padding - 0 or positive integer value.}

\item{padding.top}{paragraph top padding - 0 or positive integer value.}

\item{padding.left}{paragraph left padding - 0 or positive integer value.}

\item{padding.right}{paragraph right padding - 0 or positive integer value.}

\item{padding}{paragraph padding - 0 or positive integer value. Argument \code{padding} overwrites
arguments \code{padding.bottom}, \code{padding.top}, \code{padding.left}, \code{padding.right}.}

\item{list.style}{list style - a single character value, expected value
is one of 'none' (default), 'unordered', 'ordered', 'blockquote'. This will not have any effect
if used in a FlexTable.}

\item{level}{list level if argument \code{list} is not 'none'. This will not have any effect
if used in a FlexTable.}

\item{border.bottom}{\code{\link{borderProperties}} for bottom border. overwrite all border.bottom.* if specified.}

\item{border.left}{\code{\link{borderProperties}} for left border. overwrite all border.left.* if specified.}

\item{border.top}{\code{\link{borderProperties}} for top border. overwrite all border.top.* if specified.}

\item{border.right}{\code{\link{borderProperties}} for right border. overwrite all border.right.* if specified.}

\item{shading.color}{shading color - a single character value specifying
a valid color (e.g. "#000000" or "black").}

\item{object}{\code{parProperties} object to update}

\item{...}{further arguments - not used}

\item{x}{\code{parProperties} object to print}
}
\value{
a \code{parProperties} object
}
\description{
Create a \code{parProperties} object that describes
paragraph formatting properties.
}
\details{
parProperties is used to control paragraph properties.
It is used when adding plots or when adding content in a FlexTable.

Default values are:
\itemize{
  \item \code{text.align} "left"
  \item \code{padding.bottom} 1
  \item \code{padding.top} 1
  \item \code{padding.left} 1
  \item \code{padding.right} 1
  \item \code{list.style} 'none'
  \item \code{level} 1
}

Get a modified version of a \code{parProperties} with
\code{chprop}.
}
\examples{
# parProperties examples -------
parProperties( text.align = "center", padding = 5)

parProperties( text.align = "center", 
  padding.top = 5,
  padding.bottom = 0,
  padding.left = 2,
  padding.right = 0
)

parProperties( list.style = "ordered", level = 2)

parProperties( list.style = "unordered", level = 2)

# chprop usage example ------
parProp = parProperties()

parProp01 = chprop( parProp, text.align = "center" )
parProp02 = chprop( parProp, padding.bottom = 2 )
parProp03 = chprop( parProp, padding.top = 2 )
parProp04 = chprop( parProp, padding.left = 2 )
parProp05 = chprop( parProp, padding = 2 )

parProp06 = chprop( parProp, padding = 2, text.align = "center" )
}
\seealso{
\code{\link{alterFlexTable}}, \code{\link{addParagraph}},
\code{\link{shortcut_properties}}
}

