% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/addTitle.pptx.R
\name{addTitle.pptx}
\alias{addTitle.pptx}
\title{Insert a title into a pptx object}
\usage{
\method{addTitle}{pptx}(doc, value, ...)
}
\arguments{
\item{doc}{\code{\link{pptx}} object}

\item{value}{\code{"character"} value to use as title text}

\item{...}{further arguments, not used.}
}
\value{
an object of class \code{\link{pptx}}.
}
\description{
Add a title into a \code{\link{pptx}} object.
}
\examples{
\dontrun{
doc.filename = "addTitle_example.pptx"

# set default font size to 24
options( "ReporteRs-fontsize" = 24 )

doc = pptx( title = "title" )

# add a slide with layout "Title and Content"
doc = addSlide( doc, slide.layout = "Title and Content" )

doc = addTitle( doc, "Title example 1" )

# Write the object
writeDoc( doc, file = doc.filename )
}
}
\seealso{
\code{\link{pptx}}, \code{\link{addTitle}}, \code{\link{addSlide.pptx}}
}

