package org.lysis.reporters.lists;

import java.math.BigInteger;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map.Entry;

import org.docx4j.wml.Numbering;
import org.docx4j.wml.Numbering.AbstractNum;
import org.docx4j.wml.Numbering.Num;
import org.docx4j.wml.Numbering.Num.AbstractNumId;
import org.lysis.reporters.tools.DOCX4R;
import org.lysis.reporters.tools.Debug;
import org.lysis.reporters.tools.HTML4R;

public class NumberingDefinition implements HTML4R, DOCX4R{
	private Numbering numbering ;
	
	private ListDefinition ordered;
	private ListDefinition unordered;
	private LinkedHashMap<Integer, Boolean> list_pointers;
	private BigInteger orderedNumAbstractID;
	private BigInteger unorderedNumAbstractID;
	private int orderedNumID;
	private int unorderedNumID;
	
	public NumberingDefinition(){
		numbering = new Numbering();
		ordered = new ListDefinition(0);
		unordered = new ListDefinition(1);
		list_pointers = new LinkedHashMap<Integer, Boolean>();
		orderedNumID = 1;
		unorderedNumID = 1;
	}
	
	public void stackToExistingList(Numbering existingNb) throws Exception{
		if( Debug.debug_list ) System.err.println("stackToExistingList");
		List<Num> existingNum = existingNb.getNum();
		List<AbstractNum> existingAbstractNum = existingNb.getAbstractNum();
		
		int maxAbstractNumId = 0;
		int maxNumId = 0;
		
		for (Iterator<AbstractNum> it1 = existingAbstractNum.iterator(); it1.hasNext();) {
			BigInteger currnum = it1.next().getAbstractNumId();
			if( Debug.debug_list ) System.err.println("Existing AbstractNumId: " + currnum.intValue() );
			if( maxAbstractNumId < currnum.intValue() ) maxAbstractNumId = currnum.intValue() ;
		}
		
		for (Iterator<Num> it1 = existingNum.iterator(); it1.hasNext();) {
			BigInteger currnum = it1.next().getNumId();
			if( Debug.debug_list ) System.err.println("Existing NumId: " + currnum.intValue() );
			if( maxNumId < currnum.intValue() ) maxNumId = currnum.intValue() ;
		}
		
//		setOrderedNumAbstractID(BigInteger.valueOf(maxAbstractNumId+1));
//		setUnorderedNumAbstractID( BigInteger.valueOf(maxAbstractNumId+2) );
		orderedNumAbstractID = BigInteger.valueOf(maxAbstractNumId+1);
		ordered.setAbstractNumID( maxAbstractNumId + 1 );
		unorderedNumAbstractID = BigInteger.valueOf(maxAbstractNumId+2);
		unordered.setAbstractNumID( maxAbstractNumId + 2 );
		
		orderedNumID = maxNumId + 1;
		unorderedNumID = maxNumId + 2;

		

		if( Debug.debug_list ) System.err.println("{1}\tAbstractNum number: " + numbering.getAbstractNum().size() );
		if( Debug.debug_list ) System.err.println("{1}\tNum number: " + numbering.getNum().size() );
		numbering.getAbstractNum().addAll(existingAbstractNum);
		numbering.getNum().addAll(existingNum);

		if( Debug.debug_list ) System.err.println("{2}\tAbstractNum number: " + numbering.getAbstractNum().size() );
		if( Debug.debug_list ) System.err.println("{2}\tNum number: " + numbering.getNum().size() );
		numbering.getAbstractNum().add(ordered.getDocxAbstractNum());
		numbering.getAbstractNum().add(unordered.getDocxAbstractNum());

		Num orderedNum = new Num();
		AbstractNumId ani1 = new AbstractNumId();
		ani1.setVal(orderedNumAbstractID);
		orderedNum.setAbstractNumId(ani1);
		orderedNum.setNumId(BigInteger.valueOf(orderedNumID));	
		numbering.getNum().add(orderedNum);

		Num unorderedNum = new Num();
		AbstractNumId ani2 = new AbstractNumId();
		ani2.setVal(unorderedNumAbstractID);
		unorderedNum.setAbstractNumId(ani2);
		unorderedNum.setNumId(BigInteger.valueOf(unorderedNumID));	
		numbering.getNum().add(unorderedNum);

		if( Debug.debug_list ) System.err.println("{3}\tAbstractNum number: " + numbering.getAbstractNum().size() );
		if( Debug.debug_list ) System.err.println("{3}\tNum number: " + numbering.getNum().size() );

		if( Debug.debug_list ) 
			for (Iterator<Num> it1 = numbering.getNum().iterator(); it1.hasNext();) {
				BigInteger currnum = it1.next().getNumId();
				System.err.println("Num " + currnum.intValue() );
			}
	}
	
	
	public int getOrderedNumID() {
		return orderedNumID;
	}

	public int getUnorderedNumID() {
		return unorderedNumID;
	}
	
	public ListDefinition getOrdered(){
		return ordered;
	}
	
	public ListDefinition getUnordered(){
		return unordered;
	}
	
	public void setOrdered( ListDefinition ordered ){
		this.ordered = ordered;
	}
	
	public void setUnOrdered( ListDefinition unordered ){
		this.unordered = unordered;
	}
	
	public void addListPointer(int list_id, boolean ordered ){
		list_pointers.put(list_id, ordered);
	}
	public boolean hasListPointer( int list_id ){
		return list_pointers.containsKey( new Integer( list_id ) );
	}
	@Override
	public Object get_docx_elt() throws Exception {
		

		
		return numbering;
	}


	@Override
	public String getCSS() {
		Iterator<Entry<Integer, Boolean>> partIterator = list_pointers.entrySet().iterator();
		String out = "";
		String counterResets = "";
		while (partIterator.hasNext()) {
			Entry<Integer, Boolean> ent = partIterator.next();
			out += ordered.getCSS(ent.getKey());
			out += unordered.getCSS(ent.getKey());
			counterResets += ordered.getCounterResets(ent.getKey());
		}
		
		return "body{counter-reset: " + counterResets + ";}" + out;
	}


	@Override
	public boolean hasJS() {
		return false;
	}

	@Override
	public boolean hasHTML() {
		return false;
	}

	@Override
	public boolean hasCSS() {
		return true;
	}

	@Override
	public String getHTML() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getJS() {
		// TODO Auto-generated method stub
		return null;
	}
	
	
	
}
