/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.docx4r.tools;

import java.util.List;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.model.structure.HeaderFooterPolicy;
import org.docx4j.model.structure.SectionWrapper;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.CTBookmark;
import org.docx4j.wml.P;
import org.lysis.reporters.docx4r.tools.BookmarkObject;

public class DocExplorer {
    private static BookmarkObject traversePartForBookmarkObject(Object parent, String bookmark) {
        BookmarkObject p = new BookmarkObject();
        bookmark = bookmark.toLowerCase();
        List children = TraversalUtil.getChildrenImpl((Object)parent);
        if (children != null) {
            for (Object o : children) {
                CTBookmark bm;
                if ((o = XmlUtils.unwrap(o)) instanceof CTBookmark && (bm = (CTBookmark)o).getName().toLowerCase().equals(bookmark)) {
                    p = new BookmarkObject((P)parent, bm);
                    return p;
                }
                p = DocExplorer.traversePartForBookmarkObject(o, bookmark);
                if (p.exists()) break;
            }
        }
        return p;
    }

    public static BookmarkObject getBookmarkObject(String bookmark, WordprocessingMLPackage wmlp) {
        BookmarkObject p = DocExplorer.traversePartForBookmarkObject(wmlp.getMainDocumentPart(), bookmark);
        if (!p.exists()) {
            List sectionWrappers = wmlp.getDocumentModel().getSections();
            for (SectionWrapper sw : sectionWrappers) {
                if (p.exists()) break;
                HeaderFooterPolicy hfp = sw.getHeaderFooterPolicy();
                if (!p.exists() && hfp.getFirstHeader() != null) {
                    p = DocExplorer.traversePartForBookmarkObject(hfp.getFirstHeader(), bookmark);
                }
                if (!p.exists() && hfp.getDefaultHeader() != null) {
                    p = DocExplorer.traversePartForBookmarkObject(hfp.getDefaultHeader(), bookmark);
                }
                if (!p.exists() && hfp.getEvenHeader() != null) {
                    p = DocExplorer.traversePartForBookmarkObject(hfp.getEvenHeader(), bookmark);
                }
                if (!p.exists() && hfp.getFirstFooter() != null) {
                    p = DocExplorer.traversePartForBookmarkObject(hfp.getFirstFooter(), bookmark);
                }
                if (!p.exists() && hfp.getDefaultFooter() != null) {
                    p = DocExplorer.traversePartForBookmarkObject(hfp.getDefaultFooter(), bookmark);
                }
                if (p.exists() || hfp.getEvenFooter() == null) continue;
                p = DocExplorer.traversePartForBookmarkObject(hfp.getEvenFooter(), bookmark);
            }
        }
        return p;
    }
}

