/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.pptx4r.elements.layouts;

import java.util.Vector;
import org.docx4j.dml.CTTransform2D;
import org.lysis.reporters.pptx4r.elements.layouts.ShapeDescription;

public class LayoutProperties {
    private String key;
    private String name;
    private Vector<ShapeDescription> contents;

    public LayoutProperties(String name, String key, Vector<ShapeDescription> props) {
        this.name = name;
        this.key = key;
        this.contents = props;
    }

    public String getName() {
        return this.name;
    }

    public String getKey() {
        return this.key;
    }

    public Vector<ShapeDescription> getContents() {
        return this.contents;
    }

    public int getMaxShape() {
        int out = 0;
        int i = 0;
        while (i < this.contents.size()) {
            if (this.contents.get(i).isContent()) {
                ++out;
            }
            ++i;
        }
        return out;
    }

    public long getShapeIdx(int id) {
        int out = 0;
        long idx = -1L;
        int i = 0;
        while (i < this.contents.size()) {
            if (this.contents.get(i).isContent()) {
                if (id == out) {
                    idx = this.contents.get(i).getIdx();
                    break;
                }
                ++out;
            }
            ++i;
        }
        return idx;
    }

    public long getShapeIdx(String type) {
        long idx = -1L;
        int i = 0;
        while (i < this.contents.size()) {
            if (this.contents.get(i).getShapeType().equals(type)) {
                idx = this.contents.get(i).getIdx();
                return idx;
            }
            ++i;
        }
        return idx;
    }

    public CTTransform2D getXfrm(int id) {
        int out = 0;
        CTTransform2D outXfrm = null;
        int i = 0;
        while (i < this.contents.size()) {
            if (this.contents.get(i).isContent()) {
                if (id == out) {
                    outXfrm = this.contents.get(i).getXfrm();
                    break;
                }
                ++out;
            }
            ++i;
        }
        return outXfrm;
    }

    public String toString() {
        String cont = "";
        int i = 0;
        while (i < this.contents.size()) {
            cont = i > 0 ? String.valueOf(cont) + ";" + this.contents.get(i) : String.valueOf(cont) + this.contents.get(i);
            ++i;
        }
        return String.valueOf(this.name) + " [" + this.key + "]\t{" + cont + "}";
    }
}

