% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poisbinom.R
\name{Poisson-Binomial}
\alias{Poisson-Binomial}
\alias{dpoisbinom}
\alias{qpoisbinom}
\alias{ppoisbinom}
\alias{rpoisbinom}
\title{The Poisson Binomial Distribution}
\usage{
dpoisbinom(x, size = 1, prob, log = FALSE)

ppoisbinom(q, size = 1, prob, lower.tail = TRUE, log.p = FALSE)

qpoisbinom(p, size = 1, prob, lower.tail = TRUE, log.p = FALSE)

rpoisbinom(n, size = 1, prob)
}
\arguments{
\item{x, q}{Vector of quantiles.}

\item{size}{The Poisson binomial distribution has \code{size} times the
vector of probabilities \code{prob}.}

\item{prob}{Vector with the probabilities of success on each trial.}

\item{log, log.p}{Logical. If \code{TRUE}, probabilities \eqn{p} are given as 
\eqn{\log(p)}.}

\item{lower.tail}{Logical. If \code{TRUE} (default), probabilities are
\eqn{P(X \le x)}, otherwise, \eqn{P(X > x)}.}

\item{p}{Vector of probabilities.}

\item{n}{Number of observations.}
}
\value{
\code{dpoisbinom} gives the density, \code{ppoisbinom} gives the 
  distribution function, \code{qpoisbinom} gives the quantile function
  and \code{rpoisbinom} generates random deviates.
  
  The length of the result is determined by \code{x}, \code{q}, \code{p}
  or \code{n}.
}
\description{
Density, distribution function, quantile function and random
  generation for the Poisson binomial distribution with parameters 
  \code{size} and \code{prob}.
  
  This is conventionally interpreted as the number of successes in 
  \code{size * length(prob)} trials with success probabilities \code{prob}.
}
\details{
The Poisson binomial distribution with \code{size = 1} and 
  \code{prob} \eqn{= (p_1,p_2,\ldots,p_n)} has density
  \deqn{p(x) = \sum_{A \in F_x} \prod_{i \in A} p_i \prod_{j \in A^c} (1-p_j)}
  for \eqn{x=0,1,\ldots,n}; where \eqn{F_x} is the set of all subsets of 
  \eqn{x} integers that can be selected from \eqn{\{1,2,\ldots,n\}}.
  
  \eqn{p(x)} is computed using Hong (2013) algorithm, see the reference 
  below. 
  
  The quantile is defined as the smallest value \eqn{x} such that 
  \eqn{F(x) \ge p}, where \eqn{F} is the cumulative distribution function.
}
\references{
Hong Y (2013). 
“On Computing the Distribution Function for the Poisson Binomial Distribution.”
\emph{Computational Statistics & Data Analysis}, \strong{59}(1), 41-51.
}
\author{
Jorge Castillo-Mateo
}
