% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_mle2.R
\name{est.mle2}
\alias{est.mle2}
\title{Maximum Likelihood Esimation with Poisson Process and Bias Correction}
\usage{
est.mle2(X, k1 = 10, k2 = 20)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations.}

\item{k1}{minimum neighborhood size, larger than 1.}

\item{k2}{maximum neighborhood size, smaller than \eqn{n}.}
}
\value{
a named list containing containing \describe{
\item{estdim}{estimated intrinsic dimension.}
}
}
\description{
Authors argue that the approach proposed in \code{\link{est.mle1}} is
empirically bias-prone in that the averaging of sample statistics over
all data points is taken to be a harmonic manner.
}
\examples{
\donttest{
## create example data sets with intrinsic dimension 2
X1 = aux.gensamples(dname="swiss")
X2 = aux.gensamples(dname="ribbon")
X3 = aux.gensamples(dname="saddle")

## acquire an estimate for intrinsic dimension
out1 = est.mle2(X1)
out2 = est.mle2(X2)
out3 = est.mle2(X3)

line1 = paste0("* est.mle2 : dimension of 'swiss'  data is ",round(out1$estdim,2))
line2 = paste0("* est.mle2 : dimension of 'ribbon' data is ",round(out2$estdim,2))
line3 = paste0("* est.mle2 : dimension of 'saddle' data is ",round(out3$estdim,2))
cat(paste0(line1,"\n",line2,"\n",line3))
}

}
\references{
\insertRef{mackay_comments_2005}{Rdimtools}
}
\author{
Kisung You
}
