% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear_MVE.R
\name{do.mve}
\alias{do.mve}
\title{Minimum Volume Embedding}
\usage{
do.mve(
  X,
  ndim = 2,
  knn = ceiling(nrow(X)/10),
  kwidth = 1,
  preprocess = c("null", "center", "scale", "cscale", "whiten", "decorrelate"),
  tol = 1e-04,
  maxiter = 1000
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{knn}{size of \eqn{k}-nn neighborhood.}

\item{kwidth}{bandwidth for Gaussian kernel.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "null". See also \code{\link{aux.preprocess}} for more details.}

\item{tol}{stopping criterion for incremental change.}

\item{maxiter}{maximum number of iterations allowed.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
}
}
\description{
Minimum Volume Embedding (MVE) is a nonlinear dimension reduction
algorithm that exploits semidefinite programming (SDP), like MVU/SDE.
Whereas MVU aims at stretching through all direction by maximizing
\eqn{\sum \lambda_i}, MVE only opts for unrolling the top eigenspectrum
and chooses to shrink left-over spectral dimension. For ease of use,
unlike kernel PCA, we only made use of Gaussian kernel for MVE. Note that
we adopted \href{https://CRAN.R-project.org/package=Rcsdp}{Rcsdp} package in that
when given large-scale dataset, it may result in extremely deteriorated computational performance.
}
\examples{
\donttest{
## generate ribbon-shaped data
## in order to pass CRAN pretest, n is set to be small.
X = aux.gensamples(dname="ribbon",n=50)

## Compare MVU and MVE
#  Note that MVE actually requires much larger number of iterations
#  Here, due to CRAN limit, it was set as 7.
outMVU5  <- do.mvu(X, ndim=2, type=c("knn",5), projtype="kpca")
outMVE5  <- do.mve(X, ndim=2, knn=5, maxiter=7)

## Visualize two comparisons
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,2))
plot(outMVU5$Y,  main="MVU (k=5)")
plot(outMVE5$Y,  main="MVE (k=5)")
par(opar)
}

}
\references{
\insertRef{shaw_minimum_2007}{Rdimtools}
}
\seealso{
\code{\link{do.mvu}}
}
\author{
Kisung You
}
\concept{nonlinear_methods}
