% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear_ILTSA.R
\name{do.iltsa}
\alias{do.iltsa}
\title{Improved Local Tangent Space Alignment}
\usage{
do.iltsa(
  X,
  ndim = 2,
  type = c("proportion", 0.1),
  symmetric = c("union", "intersect", "asymmetric"),
  preprocess = c("center", "scale", "cscale", "decorrelate", "whiten"),
  t = 10
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{type}{a vector of neighborhood graph construction. Following types are supported;
\code{c("knn",k)}, \code{c("enn",radius)}, and \code{c("proportion",ratio)}.
Default is \code{c("proportion",0.1)}, connecting about 1/10 of nearest data points
among all data points. See also \code{\link{aux.graphnbd}} for more details.}

\item{symmetric}{one of \code{"intersect"}, \code{"union"} or \code{"asymmetric"} is supported. Default is \code{"union"}. See also \code{\link{aux.graphnbd}} for more details.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center". See also \code{\link{aux.preprocess}} for more details.}

\item{t}{heat kernel bandwidth parameter in \eqn{(0,\infty)}.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
}
}
\description{
Conventional LTSA method relies on PCA for approximating local tangent spaces.
Improved LTSA (ILTSA) provides a remedy that can efficiently recover the geometric
structure of data manifolds even when data are sparse or non-uniformly distributed.
}
\examples{
\donttest{
## generate ribbon-shaped data
X = aux.gensamples(dname="ribbon", n=200)

## try different bandwidth size
out1 <- do.iltsa(X, t=1)
out2 <- do.iltsa(X, t=100)
out3 <- do.iltsa(X, t=Inf)

## Visualize two comparisons
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, main="ILTSA::t=1")
plot(out2$Y, main="ILTSA::t=100")
plot(out3$Y, main="ILTSA::t=Inf")
par(opar)
}

}
\references{
\insertRef{zhang_improved_2011}{Rdimtools}
}
\author{
Kisung You
}
\concept{nonlinear_methods}
