% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_SAVE.R
\name{do.save}
\alias{do.save}
\title{Sliced Average Variance Estimation}
\usage{
do.save(X, response, ndim = 2, h = max(2, round(nrow(X)/5)),
  preprocess = c("center", "scale", "cscale", "decorrelate", "whiten"))
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{response}{a length-\eqn{n} vector of response variable.}

\item{ndim}{an integer-valued target dimension.}

\item{h}{the number of slices to divide the range of response vector.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center". See also \code{\link{aux.preprocess}} for more details.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Sliced Average Variance Estimation (SAVE) is a supervised linear dimension reduction method.
It is based on sufficiency principle with respect to central subspace concept under the
linerity and constant covariance conditions. For more details, see the reference paper.
}
\examples{
## generate swiss roll with auxiliary dimensions
## it follows reference example from LSIR paper.
n = 123
theta = runif(n)
h     = runif(n)
t     = (1+2*theta)*(3*pi/2)
X     = array(0,c(n,10))
X[,1] = t*cos(t)
X[,2] = 21*h
X[,3] = t*sin(t)
X[,4:10] = matrix(runif(7*n), nrow=n)

## corresponding response vector
y = sin(5*pi*theta)+(runif(n)*sqrt(0.1))

## try with different numbers of slices
out1 = do.save(X, y, h=2)
out2 = do.save(X, y, h=5)
out3 = do.save(X, y, h=10)

## visualize
par(mfrow=c(1,3))
plot(out1$Y[,1], out1$Y[,2], main="SAVE::2 slices")
plot(out2$Y[,1], out2$Y[,2], main="SAVE::5 slices")
plot(out3$Y[,1], out3$Y[,2], main="SAVE::10 slices")

}
\references{
\insertRef{dennis_cook_save:_2000}{Rdimtools}
}
\seealso{
\code{\link{do.sir}}
}
\author{
Kisung You
}
