% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_DSPP.R
\name{do.dspp}
\alias{do.dspp}
\title{Discriminative Sparsity Preserving Projection}
\usage{
do.dspp(X, label, ndim = 2, preprocess = c("center", "scale", "cscale",
  "decorrelate", "whiten"), lambda = 1, rho = 1)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations.}

\item{label}{a length-\eqn{n} vector of data class labels.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center". See also \code{\link{aux.preprocess}} for more details.}

\item{lambda}{regularization parameter for constructing sparsely weighted network.}

\item{rho}{a parameter for balancing the local and global contribution.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Discriminative Sparsity Preserving Projection (DSPP) is a supervised dimension reduction method
that employs sparse representation model to adaptively build both intrinsic adjacency graph and
penalty graph. It follows an integration of global within-class structure into manifold learning
under exploiting discriminative nature provided from label information.
}
\examples{
\dontrun{
## generate data of 2 types with clear difference
diff = 15
dt1  = aux.gensamples(n=123)-diff;
dt2  = aux.gensamples(n=123)+diff;

## merge the data and create a label correspondingly
Y      = rbind(dt1,dt2)
label  = c(rep(1,123), rep(2,123))

## try different rho values
out1 <- do.dspp(Y, label, ndim=2, rho=0.01)
out2 <- do.dspp(Y, label, ndim=2, rho=0.1)
out3 <- do.dspp(Y, label, ndim=2, rho=1)

## visualize
par(mfrow=c(1,3))
plot(out1$Y[,1], out1$Y[,2], main="rho=0.01")
plot(out2$Y[,1], out2$Y[,2], main="rho=0.1")
plot(out3$Y[,1], out3$Y[,2], main="rho=1")
}

}
\references{
\insertRef{gao_discriminative_2015}{Rdimtools}
}
\author{
Kisung You
}
