\name{reformat_code}
\alias{reformat_code}
\title{Format the code in the examples section}
\usage{
  reformat_code(path, ...)
}
\arguments{
  \item{path}{the path of the Rd file}

  \item{...}{other arguments passed to \code{tidy.source}}
}
\value{
  \code{TRUE} if the macro \code{"\\dontrun"} is detected
  in the Rd; \code{FALSE} if not detected or there is no
  examples section or it fails to reformat the code; as a
  side effect, the original Rd file will be updated
}
\description{
  The function \code{\link[formatR]{tidy.source}} in the
  \pkg{formatR} package is used to polish the Rd files
  generated by \pkg{roxygen2} in the examples section.
}
\details{
  If the macro \code{"\\dontrun"} is detected in the Rd
  file, this function will use an unstable way to reformat
  the examples section, which might destroy the original Rd
  (e.g. the subsection macro can be mangled); otherwise it
  will use ordinary text-processing techniques to deal with
  these sections and generally will not affect other
  sections. However, neither way is absolutely safe.
  Whenever you run into troubles, just try to turn off
  reformatting.
}
\note{
  If the examples code is not syntactically correct, it
  will not be reformatted and a message will be printed on
  screen. One possible situation is the percent symbol
  \code{\%}, which should be escaped even in the examples
  code (cf Writing R Extensions), and this can make the
  code syntactically incorrect, e.g. \code{a \%in\% b}
  should be \code{a \\\%in\\\% b} but the latter is not
  valid R code.
}
\examples{
rd.file = system.file("examples", "reformat_code_demo.Rd", 
    package = "Rd2roxygen")
file.copy(rd.file, tempdir())
fmt.file = file.path(tempdir(), "reformat_code_demo.Rd")

file.show(fmt.file)  ## show the raw Rd

reformat_code(fmt.file)
file.show(fmt.file)  ## the formatted Rd
}
\author{
  Yihui Xie <\url{http://yihui.name}>
}
\seealso{
  \code{\link[formatR]{tidy.source}}
}
