% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcplfit_hillbase.R
\name{get_hill_fit_config}
\alias{get_hill_fit_config}
\title{Get the default configurations for the Hill fit}
\usage{
get_hill_fit_config(Conc, Resp, optimf = "tcplObjHill")
}
\arguments{
\item{Conc}{A vector of log10 concentrations.}

\item{Resp}{A vector of numeric responses.}

\item{optimf}{The default optimized function is \code{\link[tcpl:Models]{tcpl::tcplObjHill()}}.
but can be changed to ObjHillnorm().}
}
\value{
A list of input configurations.

\itemize{
\item theta: initial values of parameters for Hill equation: tp, ga, gw, er
\item f: the object function
\item ui: the bound matrix
\item ci: the bound constraints
}
}
\description{
The function gives the default settings by using one set of concentration-response data.
}
\seealso{
\code{\link[tcpl:Models]{tcpl::tcplObjHill()}}, \code{\link[=fit_modls]{fit_modls()}}
}
