// [[Rcpp::plugins(cpp11)]]
// [[Rcpp::depends(BH)]]
/*
(c) 2014 Glen Joseph Fernandes
<glenjofe -at- gmail.com>

Distributed under the Boost Software
License, Version 1.0.
http://boost.org/LICENSE_1_0.txt
*/
#ifndef BOOST_ALIGN_DETAIL_ALIGNED_ALLOC_ANDROID_HPP
#define BOOST_ALIGN_DETAIL_ALIGNED_ALLOC_ANDROID_HPP

#include "is_alignment.hpp"

#include <malloc.h>

namespace boost {
namespace alignment {

inline void* aligned_alloc(std::size_t alignment, std::size_t size)
    BOOST_NOEXCEPT
{
    BOOST_ASSERT(detail::is_alignment(alignment));
    return ::memalign(alignment, size);
}

inline void aligned_free(void* ptr) BOOST_NOEXCEPT
{
    ::free(ptr);
}

} /* .alignment */
} /* .boost */

#endif

