% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cl.R
\name{cl_struc_values}
\alias{cl_struc_values}
\title{Check whether structural attribute has values}
\usage{
cl_struc_values(corpus, s_attribute, registry = Sys.getenv("CORPUS_REGISTRY"))
}
\arguments{
\item{corpus}{Corpus ID, a length-one \code{character} vector.}

\item{s_attribute}{Structural attribute to check, a length-one \code{character} vector.}

\item{registry}{The registry directory of the corpus.}
}
\value{
\code{TRUE} if the attribute has values and \code{FALSE} if not. \code{NA} if the structural
attribute is not available.
}
\description{
Structural attributes do not necessarily have values, structural attributes
(such as annotations of sentences or paragraphs) may just define regions of
corpus positions. Use this function to test whether an attribute has values.
}
\examples{
cl_struc_values("REUTERS", "places") # TRUE - attribute has values
cl_struc_values("REUTERS", "date") # NA - attribute does not exist
}
