//=================================================================================================
/*!
//  \file blaze/math/DenseVector.h
//  \brief Header file for all basic DenseVector functionality
//
//  Copyright (C) 2013 Klaus Iglberger - All Rights Reserved
//
//  This file is part of the Blaze library. You can redistribute it and/or modify it under
//  the terms of the New (Revised) BSD License. Redistribution and use in source and binary
//  forms, with or without modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright notice, this list of
//     conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright notice, this list
//     of conditions and the following disclaimer in the documentation and/or other materials
//     provided with the distribution.
//  3. Neither the names of the Blaze development group nor the names of its contributors
//     may be used to endorse or promote products derived from this software without specific
//     prior written permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
//  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
//  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
//  SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
//  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
//  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
//  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
//  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
//  ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
*/
//=================================================================================================

#ifndef _BLAZE_MATH_DENSEVECTOR_H_
#define _BLAZE_MATH_DENSEVECTOR_H_


//*************************************************************************************************
// Includes
//*************************************************************************************************

#include <blaze/math/dense/DenseVector.h>
#include <blaze/math/expressions/DenseVector.h>
#include <blaze/math/expressions/DVecAbsExpr.h>
#include <blaze/math/expressions/DVecConjExpr.h>
#include <blaze/math/expressions/DVecDVecAddExpr.h>
#include <blaze/math/expressions/DVecDVecCrossExpr.h>
#include <blaze/math/expressions/DVecDVecMultExpr.h>
#include <blaze/math/expressions/DVecDVecSubExpr.h>
#include <blaze/math/expressions/DVecEvalExpr.h>
#include <blaze/math/expressions/DVecImagExpr.h>
#include <blaze/math/expressions/DVecRealExpr.h>
#include <blaze/math/expressions/DVecScalarDivExpr.h>
#include <blaze/math/expressions/DVecScalarMultExpr.h>
#include <blaze/math/expressions/DVecSerialExpr.h>
#include <blaze/math/expressions/DVecSVecAddExpr.h>
#include <blaze/math/expressions/DVecSVecCrossExpr.h>
#include <blaze/math/expressions/DVecSVecSubExpr.h>
#include <blaze/math/expressions/DVecTransExpr.h>
#include <blaze/math/expressions/SparseVector.h>
#include <blaze/math/expressions/SVecDVecCrossExpr.h>
#include <blaze/math/expressions/SVecDVecSubExpr.h>
#include <blaze/math/expressions/SVecSVecCrossExpr.h>
#include <blaze/math/expressions/TDVecDVecMultExpr.h>
#include <blaze/math/smp/DenseVector.h>
#include <blaze/math/smp/SparseVector.h>
#include <blaze/math/Vector.h>

#endif
