# Copyright (C)        2009 Romain Francois
#
# This file is part of Rcpp.
#
# Rcpp is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
#
# Rcpp is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rcpp.  If not, see <http://www.gnu.org/licenses/>.

dumpUnitTestReport <- function(){
	txt <- system.file( "doc", "Rcpp-unitTests.txt", package = "Rcpp" )
	if( file.exists( txt ) ) paste( readLines( txt ), collapse = "\n\n" ) else ""
}

.onAttach <- function(libname, pkgname){
	.Call( "initUncaughtExceptionHandler", PACKAGE = pkgname )
}
