// -*- mode: C++; c-indent-level: 4; c-basic-offset: 4; tab-width: 8 -*-
//
// Module_generated_CppMethod.h: Rcpp R/C++ interface class library -- Rcpp modules
//
// Copyright (C) 2010-2012  Doug Bates, Dirk Eddelbuettel and Romain Francois
//
// This file is part of Rcpp.
//
// Rcpp is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// Rcpp is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Rcpp.  If not, see <http://www.gnu.org/licenses/>.

#ifndef Rcpp_Module_generated_Pointer_CppMethod_h
#define Rcpp_Module_generated_Pointer_CppMethod_h


	template <typename Class, typename OUT> class Pointer_CppMethod0 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*) ;
		typedef CppMethod<Class> method_class ;
		Pointer_CppMethod0( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* ){
			return Rcpp::module_wrap<OUT>( met(object) ) ;
		}
		inline int nargs(){ return 0 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template <typename Class> class Pointer_CppMethod0<Class,void> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*) ;
		typedef CppMethod<Class> method_class ;
		Pointer_CppMethod0( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* ){
			met( object ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 0 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
    
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	
	
	
	template <typename Class, typename OUT> class Const_Pointer_CppMethod0 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*) ;
		typedef CppMethod<Class> method_class ;
		Const_Pointer_CppMethod0( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* ){
			return Rcpp::module_wrap<OUT>( met(object) ) ;
		}
		inline int nargs(){ return 0 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template <typename Class> class Const_Pointer_CppMethod0<Class,void> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*) ;
		typedef CppMethod<Class> method_class ;
		Const_Pointer_CppMethod0( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* ){
			met( object ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 0 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
    
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	


	template < typename Class, typename OUT, typename U0 > class Pointer_CppMethod1 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod1(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ) ) ) ;
		}
		inline int nargs(){ return 1 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0 > class Pointer_CppMethod1<Class,void,U0> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod1( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 1 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0 > class Const_Pointer_CppMethod1 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod1(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ) ) ) ;
		}
		inline int nargs(){ return 1 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0 > class Const_Pointer_CppMethod1<Class,void,U0> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod1( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 1 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1 > class Pointer_CppMethod2 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod2(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ) ) ) ;
		}
		inline int nargs(){ return 2 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1 > class Pointer_CppMethod2<Class,void,U0, U1> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod2( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 2 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1 > class Const_Pointer_CppMethod2 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod2(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ) ) ) ;
		}
		inline int nargs(){ return 2 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1 > class Const_Pointer_CppMethod2<Class,void,U0, U1> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod2( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 2 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2 > class Pointer_CppMethod3 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod3(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ) ) ) ;
		}
		inline int nargs(){ return 3 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2 > class Pointer_CppMethod3<Class,void,U0, U1, U2> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod3( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 3 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2 > class Const_Pointer_CppMethod3 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod3(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ) ) ) ;
		}
		inline int nargs(){ return 3 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2 > class Const_Pointer_CppMethod3<Class,void,U0, U1, U2> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod3( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 3 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3 > class Pointer_CppMethod4 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod4(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ) ) ) ;
		}
		inline int nargs(){ return 4 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3 > class Pointer_CppMethod4<Class,void,U0, U1, U2, U3> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod4( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 4 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3 > class Const_Pointer_CppMethod4 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod4(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ) ) ) ;
		}
		inline int nargs(){ return 4 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3 > class Const_Pointer_CppMethod4<Class,void,U0, U1, U2, U3> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod4( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 4 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4 > class Pointer_CppMethod5 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod5(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ) ) ) ;
		}
		inline int nargs(){ return 5 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4 > class Pointer_CppMethod5<Class,void,U0, U1, U2, U3, U4> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod5( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 5 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4 > class Const_Pointer_CppMethod5 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod5(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ) ) ) ;
		}
		inline int nargs(){ return 5 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4 > class Const_Pointer_CppMethod5<Class,void,U0, U1, U2, U3, U4> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod5( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 5 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5 > class Pointer_CppMethod6 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod6(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ) ) ) ;
		}
		inline int nargs(){ return 6 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5 > class Pointer_CppMethod6<Class,void,U0, U1, U2, U3, U4, U5> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod6( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 6 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5 > class Const_Pointer_CppMethod6 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod6(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ) ) ) ;
		}
		inline int nargs(){ return 6 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5 > class Const_Pointer_CppMethod6<Class,void,U0, U1, U2, U3, U4, U5> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod6( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 6 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6 > class Pointer_CppMethod7 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod7(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ) ) ) ;
		}
		inline int nargs(){ return 7 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6 > class Pointer_CppMethod7<Class,void,U0, U1, U2, U3, U4, U5, U6> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod7( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 7 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6 > class Const_Pointer_CppMethod7 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod7(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ) ) ) ;
		}
		inline int nargs(){ return 7 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6 > class Const_Pointer_CppMethod7<Class,void,U0, U1, U2, U3, U4, U5, U6> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod7( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 7 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7 > class Pointer_CppMethod8 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod8(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ) ) ) ;
		}
		inline int nargs(){ return 8 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7 > class Pointer_CppMethod8<Class,void,U0, U1, U2, U3, U4, U5, U6, U7> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod8( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 8 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7 > class Const_Pointer_CppMethod8 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod8(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ) ) ) ;
		}
		inline int nargs(){ return 8 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7 > class Const_Pointer_CppMethod8<Class,void,U0, U1, U2, U3, U4, U5, U6, U7> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod8( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 8 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8 > class Pointer_CppMethod9 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod9(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ) ) ) ;
		}
		inline int nargs(){ return 9 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8 > class Pointer_CppMethod9<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod9( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 9 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8 > class Const_Pointer_CppMethod9 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod9(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ) ) ) ;
		}
		inline int nargs(){ return 9 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8 > class Const_Pointer_CppMethod9<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod9( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 9 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9 > class Pointer_CppMethod10 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod10(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ) ) ) ;
		}
		inline int nargs(){ return 10 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9 > class Pointer_CppMethod10<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod10( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 10 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9 > class Const_Pointer_CppMethod10 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod10(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ) ) ) ;
		}
		inline int nargs(){ return 10 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9 > class Const_Pointer_CppMethod10<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod10( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 10 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10 > class Pointer_CppMethod11 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod11(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ) ) ) ;
		}
		inline int nargs(){ return 11 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10 > class Pointer_CppMethod11<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod11( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 11 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10 > class Const_Pointer_CppMethod11 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod11(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ) ) ) ;
		}
		inline int nargs(){ return 11 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10 > class Const_Pointer_CppMethod11<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod11( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 11 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11 > class Pointer_CppMethod12 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod12(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ) ) ) ;
		}
		inline int nargs(){ return 12 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11 > class Pointer_CppMethod12<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod12( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 12 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11 > class Const_Pointer_CppMethod12 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod12(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ) ) ) ;
		}
		inline int nargs(){ return 12 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11 > class Const_Pointer_CppMethod12<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod12( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 12 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12 > class Pointer_CppMethod13 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod13(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ) ) ) ;
		}
		inline int nargs(){ return 13 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12 > class Pointer_CppMethod13<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod13( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 13 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12 > class Const_Pointer_CppMethod13 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod13(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ) ) ) ;
		}
		inline int nargs(){ return 13 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12 > class Const_Pointer_CppMethod13<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod13( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 13 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13 > class Pointer_CppMethod14 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod14(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ) ) ) ;
		}
		inline int nargs(){ return 14 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13 > class Pointer_CppMethod14<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod14( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 14 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13 > class Const_Pointer_CppMethod14 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod14(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ) ) ) ;
		}
		inline int nargs(){ return 14 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13 > class Const_Pointer_CppMethod14<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod14( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 14 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14 > class Pointer_CppMethod15 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod15(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ) ) ) ;
		}
		inline int nargs(){ return 15 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14 > class Pointer_CppMethod15<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod15( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 15 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14 > class Const_Pointer_CppMethod15 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod15(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ) ) ) ;
		}
		inline int nargs(){ return 15 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14 > class Const_Pointer_CppMethod15<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod15( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 15 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15 > class Pointer_CppMethod16 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod16(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ) ) ) ;
		}
		inline int nargs(){ return 16 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15 > class Pointer_CppMethod16<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod16( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 16 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15 > class Const_Pointer_CppMethod16 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod16(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ) ) ) ;
		}
		inline int nargs(){ return 16 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15 > class Const_Pointer_CppMethod16<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod16( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 16 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16 > class Pointer_CppMethod17 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod17(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ) ) ) ;
		}
		inline int nargs(){ return 17 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16 > class Pointer_CppMethod17<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod17( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 17 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16 > class Const_Pointer_CppMethod17 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod17(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ) ) ) ;
		}
		inline int nargs(){ return 17 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16 > class Const_Pointer_CppMethod17<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod17( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 17 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17 > class Pointer_CppMethod18 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod18(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ) ) ) ;
		}
		inline int nargs(){ return 18 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17 > class Pointer_CppMethod18<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod18( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 18 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17 > class Const_Pointer_CppMethod18 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod18(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ) ) ) ;
		}
		inline int nargs(){ return 18 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17 > class Const_Pointer_CppMethod18<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod18( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 18 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18 > class Pointer_CppMethod19 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod19(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ) ) ) ;
		}
		inline int nargs(){ return 19 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18 > class Pointer_CppMethod19<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod19( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 19 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18 > class Const_Pointer_CppMethod19 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod19(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ) ) ) ;
		}
		inline int nargs(){ return 19 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18 > class Const_Pointer_CppMethod19<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod19( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 19 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19 > class Pointer_CppMethod20 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod20(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ) ) ) ;
		}
		inline int nargs(){ return 20 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19 > class Pointer_CppMethod20<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod20( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 20 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19 > class Const_Pointer_CppMethod20 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod20(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ) ) ) ;
		}
		inline int nargs(){ return 20 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19 > class Const_Pointer_CppMethod20<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod20( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 20 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20 > class Pointer_CppMethod21 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod21(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ) ) ) ;
		}
		inline int nargs(){ return 21 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20 > class Pointer_CppMethod21<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod21( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 21 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20 > class Const_Pointer_CppMethod21 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod21(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ) ) ) ;
		}
		inline int nargs(){ return 21 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20 > class Const_Pointer_CppMethod21<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod21( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 21 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21 > class Pointer_CppMethod22 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod22(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ) ) ) ;
		}
		inline int nargs(){ return 22 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21 > class Pointer_CppMethod22<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod22( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 22 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21 > class Const_Pointer_CppMethod22 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod22(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ) ) ) ;
		}
		inline int nargs(){ return 22 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21 > class Const_Pointer_CppMethod22<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod22( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 22 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22 > class Pointer_CppMethod23 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod23(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ) ) ) ;
		}
		inline int nargs(){ return 23 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22 > class Pointer_CppMethod23<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod23( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 23 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22 > class Const_Pointer_CppMethod23 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod23(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ) ) ) ;
		}
		inline int nargs(){ return 23 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22 > class Const_Pointer_CppMethod23<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod23( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 23 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23 > class Pointer_CppMethod24 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod24(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ) ) ) ;
		}
		inline int nargs(){ return 24 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23 > class Pointer_CppMethod24<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod24( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 24 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23 > class Const_Pointer_CppMethod24 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod24(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ) ) ) ;
		}
		inline int nargs(){ return 24 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23 > class Const_Pointer_CppMethod24<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod24( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 24 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24 > class Pointer_CppMethod25 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod25(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ) ) ) ;
		}
		inline int nargs(){ return 25 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24 > class Pointer_CppMethod25<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod25( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 25 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24 > class Const_Pointer_CppMethod25 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod25(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ) ) ) ;
		}
		inline int nargs(){ return 25 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24 > class Const_Pointer_CppMethod25<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod25( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 25 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25 > class Pointer_CppMethod26 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod26(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ) ) ) ;
		}
		inline int nargs(){ return 26 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25 > class Pointer_CppMethod26<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod26( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 26 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25 > class Const_Pointer_CppMethod26 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod26(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ) ) ) ;
		}
		inline int nargs(){ return 26 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25 > class Const_Pointer_CppMethod26<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod26( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 26 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26 > class Pointer_CppMethod27 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod27(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ) ) ) ;
		}
		inline int nargs(){ return 27 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26 > class Pointer_CppMethod27<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod27( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 27 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26 > class Const_Pointer_CppMethod27 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod27(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ) ) ) ;
		}
		inline int nargs(){ return 27 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26 > class Const_Pointer_CppMethod27<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod27( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 27 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27 > class Pointer_CppMethod28 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod28(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ) ) ) ;
		}
		inline int nargs(){ return 28 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27 > class Pointer_CppMethod28<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod28( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 28 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27 > class Const_Pointer_CppMethod28 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod28(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ) ) ) ;
		}
		inline int nargs(){ return 28 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27 > class Const_Pointer_CppMethod28<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod28( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 28 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28 > class Pointer_CppMethod29 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod29(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ) ) ) ;
		}
		inline int nargs(){ return 29 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28 > class Pointer_CppMethod29<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod29( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 29 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28 > class Const_Pointer_CppMethod29 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod29(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ) ) ) ;
		}
		inline int nargs(){ return 29 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28 > class Const_Pointer_CppMethod29<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod29( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 29 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29 > class Pointer_CppMethod30 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod30(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ) ) ) ;
		}
		inline int nargs(){ return 30 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29 > class Pointer_CppMethod30<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod30( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 30 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29 > class Const_Pointer_CppMethod30 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod30(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ) ) ) ;
		}
		inline int nargs(){ return 30 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29 > class Const_Pointer_CppMethod30<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod30( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 30 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30 > class Pointer_CppMethod31 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod31(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ) ) ) ;
		}
		inline int nargs(){ return 31 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30 > class Pointer_CppMethod31<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod31( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 31 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30 > class Const_Pointer_CppMethod31 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod31(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ) ) ) ;
		}
		inline int nargs(){ return 31 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30 > class Const_Pointer_CppMethod31<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod31( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 31 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31 > class Pointer_CppMethod32 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod32(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ) ) ) ;
		}
		inline int nargs(){ return 32 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31 > class Pointer_CppMethod32<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod32( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 32 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31 > class Const_Pointer_CppMethod32 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod32(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ) ) ) ;
		}
		inline int nargs(){ return 32 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31 > class Const_Pointer_CppMethod32<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod32( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 32 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32 > class Pointer_CppMethod33 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod33(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ) ) ) ;
		}
		inline int nargs(){ return 33 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32 > class Pointer_CppMethod33<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod33( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 33 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32 > class Const_Pointer_CppMethod33 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod33(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ) ) ) ;
		}
		inline int nargs(){ return 33 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32 > class Const_Pointer_CppMethod33<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod33( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 33 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33 > class Pointer_CppMethod34 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod34(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ) ) ) ;
		}
		inline int nargs(){ return 34 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33 > class Pointer_CppMethod34<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod34( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 34 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33 > class Const_Pointer_CppMethod34 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod34(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ) ) ) ;
		}
		inline int nargs(){ return 34 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33 > class Const_Pointer_CppMethod34<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod34( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 34 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34 > class Pointer_CppMethod35 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod35(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ) ) ) ;
		}
		inline int nargs(){ return 35 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34 > class Pointer_CppMethod35<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod35( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 35 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34 > class Const_Pointer_CppMethod35 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod35(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ) ) ) ;
		}
		inline int nargs(){ return 35 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34 > class Const_Pointer_CppMethod35<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod35( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 35 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35 > class Pointer_CppMethod36 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod36(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ) ) ) ;
		}
		inline int nargs(){ return 36 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35 > class Pointer_CppMethod36<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod36( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 36 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35 > class Const_Pointer_CppMethod36 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod36(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ) ) ) ;
		}
		inline int nargs(){ return 36 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35 > class Const_Pointer_CppMethod36<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod36( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 36 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36 > class Pointer_CppMethod37 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod37(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ) ) ) ;
		}
		inline int nargs(){ return 37 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36 > class Pointer_CppMethod37<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod37( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 37 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36 > class Const_Pointer_CppMethod37 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod37(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ) ) ) ;
		}
		inline int nargs(){ return 37 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36 > class Const_Pointer_CppMethod37<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod37( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 37 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37 > class Pointer_CppMethod38 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod38(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ) ) ) ;
		}
		inline int nargs(){ return 38 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37 > class Pointer_CppMethod38<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod38( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 38 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37 > class Const_Pointer_CppMethod38 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod38(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ) ) ) ;
		}
		inline int nargs(){ return 38 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37 > class Const_Pointer_CppMethod38<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod38( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 38 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38 > class Pointer_CppMethod39 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod39(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ) ) ) ;
		}
		inline int nargs(){ return 39 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38 > class Pointer_CppMethod39<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod39( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 39 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38 > class Const_Pointer_CppMethod39 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod39(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ) ) ) ;
		}
		inline int nargs(){ return 39 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38 > class Const_Pointer_CppMethod39<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod39( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 39 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39 > class Pointer_CppMethod40 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod40(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ) ) ) ;
		}
		inline int nargs(){ return 40 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39 > class Pointer_CppMethod40<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod40( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 40 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39 > class Const_Pointer_CppMethod40 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod40(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ) ) ) ;
		}
		inline int nargs(){ return 40 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39 > class Const_Pointer_CppMethod40<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod40( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 40 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40 > class Pointer_CppMethod41 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod41(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ) ) ) ;
		}
		inline int nargs(){ return 41 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40 > class Pointer_CppMethod41<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod41( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 41 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40 > class Const_Pointer_CppMethod41 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod41(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ) ) ) ;
		}
		inline int nargs(){ return 41 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40 > class Const_Pointer_CppMethod41<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod41( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 41 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41 > class Pointer_CppMethod42 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod42(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ) ) ) ;
		}
		inline int nargs(){ return 42 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41 > class Pointer_CppMethod42<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod42( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 42 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41 > class Const_Pointer_CppMethod42 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod42(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ) ) ) ;
		}
		inline int nargs(){ return 42 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41 > class Const_Pointer_CppMethod42<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod42( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 42 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42 > class Pointer_CppMethod43 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod43(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ) ) ) ;
		}
		inline int nargs(){ return 43 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42 > class Pointer_CppMethod43<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod43( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 43 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42 > class Const_Pointer_CppMethod43 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod43(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ) ) ) ;
		}
		inline int nargs(){ return 43 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42 > class Const_Pointer_CppMethod43<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod43( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 43 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43 > class Pointer_CppMethod44 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod44(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ) ) ) ;
		}
		inline int nargs(){ return 44 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43 > class Pointer_CppMethod44<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod44( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 44 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43 > class Const_Pointer_CppMethod44 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod44(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ) ) ) ;
		}
		inline int nargs(){ return 44 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43 > class Const_Pointer_CppMethod44<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod44( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 44 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44 > class Pointer_CppMethod45 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod45(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ) ) ) ;
		}
		inline int nargs(){ return 45 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44 > class Pointer_CppMethod45<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod45( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 45 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44 > class Const_Pointer_CppMethod45 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod45(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ) ) ) ;
		}
		inline int nargs(){ return 45 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44 > class Const_Pointer_CppMethod45<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod45( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 45 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45 > class Pointer_CppMethod46 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod46(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ) ) ) ;
		}
		inline int nargs(){ return 46 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45 > class Pointer_CppMethod46<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod46( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 46 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45 > class Const_Pointer_CppMethod46 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod46(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ) ) ) ;
		}
		inline int nargs(){ return 46 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45 > class Const_Pointer_CppMethod46<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod46( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 46 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46 > class Pointer_CppMethod47 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod47(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ) ) ) ;
		}
		inline int nargs(){ return 47 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46 > class Pointer_CppMethod47<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod47( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 47 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46 > class Const_Pointer_CppMethod47 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod47(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ) ) ) ;
		}
		inline int nargs(){ return 47 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46 > class Const_Pointer_CppMethod47<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod47( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 47 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47 > class Pointer_CppMethod48 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod48(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ) ) ) ;
		}
		inline int nargs(){ return 48 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47 > class Pointer_CppMethod48<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod48( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 48 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47 > class Const_Pointer_CppMethod48 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod48(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ) ) ) ;
		}
		inline int nargs(){ return 48 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47 > class Const_Pointer_CppMethod48<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod48( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 48 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48 > class Pointer_CppMethod49 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod49(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ) ) ) ;
		}
		inline int nargs(){ return 49 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48 > class Pointer_CppMethod49<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod49( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 49 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48 > class Const_Pointer_CppMethod49 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod49(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ) ) ) ;
		}
		inline int nargs(){ return 49 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48 > class Const_Pointer_CppMethod49<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod49( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 49 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49 > class Pointer_CppMethod50 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod50(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U49 >::type >( args[49] ) ) ) ;
		}
		inline int nargs(){ return 50 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49 > class Pointer_CppMethod50<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod50( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U49 >::type >( args[49] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 50 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49 > class Const_Pointer_CppMethod50 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod50(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U49 >::type >( args[49] ) ) ) ;
		}
		inline int nargs(){ return 50 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49 > class Const_Pointer_CppMethod50<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod50( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U49 >::type >( args[49] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 50 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49, typename U50 > class Pointer_CppMethod51 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49, U50 u50) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod51(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U49 >::type >( args[49] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U50 >::type >( args[50] ) ) ) ;
		}
		inline int nargs(){ return 51 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49, typename U50 > class Pointer_CppMethod51<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49, U50 u50) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod51( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U49 >::type >( args[49] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U50 >::type >( args[50] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 51 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49, typename U50 > class Const_Pointer_CppMethod51 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49, U50 u50) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod51(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U49 >::type >( args[49] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U50 >::type >( args[50] ) ) ) ;
		}
		inline int nargs(){ return 51 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49, typename U50 > class Const_Pointer_CppMethod51<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49, U50 u50) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod51( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U49 >::type >( args[49] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U50 >::type >( args[50] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 51 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49, typename U50, typename U51 > class Pointer_CppMethod52 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49, U50 u50, U51 u51) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod52(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U49 >::type >( args[49] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U50 >::type >( args[50] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U51 >::type >( args[51] ) ) ) ;
		}
		inline int nargs(){ return 52 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49, typename U50, typename U51 > class Pointer_CppMethod52<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49, U50 u50, U51 u51) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod52( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U49 >::type >( args[49] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U50 >::type >( args[50] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U51 >::type >( args[51] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 52 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49, typename U50, typename U51 > class Const_Pointer_CppMethod52 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49, U50 u50, U51 u51) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod52(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U49 >::type >( args[49] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U50 >::type >( args[50] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U51 >::type >( args[51] ) ) ) ;
		}
		inline int nargs(){ return 52 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49, typename U50, typename U51 > class Const_Pointer_CppMethod52<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49, U50 u50, U51 u51) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod52( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U49 >::type >( args[49] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U50 >::type >( args[50] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U51 >::type >( args[51] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 52 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49, typename U50, typename U51, typename U52 > class Pointer_CppMethod53 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49, U50 u50, U51 u51, U52 u52) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod53(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U49 >::type >( args[49] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U50 >::type >( args[50] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U51 >::type >( args[51] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U52 >::type >( args[52] ) ) ) ;
		}
		inline int nargs(){ return 53 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49, typename U50, typename U51, typename U52 > class Pointer_CppMethod53<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49, U50 u50, U51 u51, U52 u52) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod53( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U49 >::type >( args[49] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U50 >::type >( args[50] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U51 >::type >( args[51] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U52 >::type >( args[52] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 53 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49, typename U50, typename U51, typename U52 > class Const_Pointer_CppMethod53 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49, U50 u50, U51 u51, U52 u52) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod53(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U49 >::type >( args[49] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U50 >::type >( args[50] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U51 >::type >( args[51] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U52 >::type >( args[52] ) ) ) ;
		}
		inline int nargs(){ return 53 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49, typename U50, typename U51, typename U52 > class Const_Pointer_CppMethod53<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49, U50 u50, U51 u51, U52 u52) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod53( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U49 >::type >( args[49] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U50 >::type >( args[50] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U51 >::type >( args[51] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U52 >::type >( args[52] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 53 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49, typename U50, typename U51, typename U52, typename U53 > class Pointer_CppMethod54 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49, U50 u50, U51 u51, U52 u52, U53 u53) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod54(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U49 >::type >( args[49] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U50 >::type >( args[50] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U51 >::type >( args[51] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U52 >::type >( args[52] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U53 >::type >( args[53] ) ) ) ;
		}
		inline int nargs(){ return 54 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52, U53>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49, typename U50, typename U51, typename U52, typename U53 > class Pointer_CppMethod54<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52, U53> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49, U50 u50, U51 u51, U52 u52, U53 u53) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod54( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U49 >::type >( args[49] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U50 >::type >( args[50] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U51 >::type >( args[51] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U52 >::type >( args[52] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U53 >::type >( args[53] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 54 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52, U53>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49, typename U50, typename U51, typename U52, typename U53 > class Const_Pointer_CppMethod54 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49, U50 u50, U51 u51, U52 u52, U53 u53) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod54(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U49 >::type >( args[49] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U50 >::type >( args[50] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U51 >::type >( args[51] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U52 >::type >( args[52] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U53 >::type >( args[53] ) ) ) ;
		}
		inline int nargs(){ return 54 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52, U53>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49, typename U50, typename U51, typename U52, typename U53 > class Const_Pointer_CppMethod54<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52, U53> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49, U50 u50, U51 u51, U52 u52, U53 u53) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod54( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U49 >::type >( args[49] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U50 >::type >( args[50] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U51 >::type >( args[51] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U52 >::type >( args[52] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U53 >::type >( args[53] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 54 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52, U53>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49, typename U50, typename U51, typename U52, typename U53, typename U54 > class Pointer_CppMethod55 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49, U50 u50, U51 u51, U52 u52, U53 u53, U54 u54) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod55(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U49 >::type >( args[49] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U50 >::type >( args[50] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U51 >::type >( args[51] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U52 >::type >( args[52] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U53 >::type >( args[53] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U54 >::type >( args[54] ) ) ) ;
		}
		inline int nargs(){ return 55 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52, U53, U54>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49, typename U50, typename U51, typename U52, typename U53, typename U54 > class Pointer_CppMethod55<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52, U53, U54> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49, U50 u50, U51 u51, U52 u52, U53 u53, U54 u54) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod55( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U49 >::type >( args[49] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U50 >::type >( args[50] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U51 >::type >( args[51] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U52 >::type >( args[52] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U53 >::type >( args[53] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U54 >::type >( args[54] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 55 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52, U53, U54>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49, typename U50, typename U51, typename U52, typename U53, typename U54 > class Const_Pointer_CppMethod55 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49, U50 u50, U51 u51, U52 u52, U53 u53, U54 u54) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod55(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U49 >::type >( args[49] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U50 >::type >( args[50] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U51 >::type >( args[51] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U52 >::type >( args[52] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U53 >::type >( args[53] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U54 >::type >( args[54] ) ) ) ;
		}
		inline int nargs(){ return 55 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52, U53, U54>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49, typename U50, typename U51, typename U52, typename U53, typename U54 > class Const_Pointer_CppMethod55<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52, U53, U54> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49, U50 u50, U51 u51, U52 u52, U53 u53, U54 u54) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod55( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U49 >::type >( args[49] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U50 >::type >( args[50] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U51 >::type >( args[51] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U52 >::type >( args[52] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U53 >::type >( args[53] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U54 >::type >( args[54] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 55 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52, U53, U54>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49, typename U50, typename U51, typename U52, typename U53, typename U54, typename U55 > class Pointer_CppMethod56 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49, U50 u50, U51 u51, U52 u52, U53 u53, U54 u54, U55 u55) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod56(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U49 >::type >( args[49] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U50 >::type >( args[50] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U51 >::type >( args[51] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U52 >::type >( args[52] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U53 >::type >( args[53] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U54 >::type >( args[54] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U55 >::type >( args[55] ) ) ) ;
		}
		inline int nargs(){ return 56 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52, U53, U54, U55>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49, typename U50, typename U51, typename U52, typename U53, typename U54, typename U55 > class Pointer_CppMethod56<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52, U53, U54, U55> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49, U50 u50, U51 u51, U52 u52, U53 u53, U54 u54, U55 u55) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod56( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U49 >::type >( args[49] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U50 >::type >( args[50] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U51 >::type >( args[51] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U52 >::type >( args[52] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U53 >::type >( args[53] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U54 >::type >( args[54] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U55 >::type >( args[55] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 56 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52, U53, U54, U55>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49, typename U50, typename U51, typename U52, typename U53, typename U54, typename U55 > class Const_Pointer_CppMethod56 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49, U50 u50, U51 u51, U52 u52, U53 u53, U54 u54, U55 u55) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod56(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U49 >::type >( args[49] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U50 >::type >( args[50] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U51 >::type >( args[51] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U52 >::type >( args[52] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U53 >::type >( args[53] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U54 >::type >( args[54] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U55 >::type >( args[55] ) ) ) ;
		}
		inline int nargs(){ return 56 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52, U53, U54, U55>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49, typename U50, typename U51, typename U52, typename U53, typename U54, typename U55 > class Const_Pointer_CppMethod56<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52, U53, U54, U55> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49, U50 u50, U51 u51, U52 u52, U53 u53, U54 u54, U55 u55) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod56( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U49 >::type >( args[49] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U50 >::type >( args[50] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U51 >::type >( args[51] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U52 >::type >( args[52] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U53 >::type >( args[53] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U54 >::type >( args[54] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U55 >::type >( args[55] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 56 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52, U53, U54, U55>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49, typename U50, typename U51, typename U52, typename U53, typename U54, typename U55, typename U56 > class Pointer_CppMethod57 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49, U50 u50, U51 u51, U52 u52, U53 u53, U54 u54, U55 u55, U56 u56) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod57(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U49 >::type >( args[49] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U50 >::type >( args[50] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U51 >::type >( args[51] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U52 >::type >( args[52] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U53 >::type >( args[53] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U54 >::type >( args[54] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U55 >::type >( args[55] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U56 >::type >( args[56] ) ) ) ;
		}
		inline int nargs(){ return 57 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52, U53, U54, U55, U56>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49, typename U50, typename U51, typename U52, typename U53, typename U54, typename U55, typename U56 > class Pointer_CppMethod57<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52, U53, U54, U55, U56> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49, U50 u50, U51 u51, U52 u52, U53 u53, U54 u54, U55 u55, U56 u56) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod57( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U49 >::type >( args[49] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U50 >::type >( args[50] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U51 >::type >( args[51] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U52 >::type >( args[52] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U53 >::type >( args[53] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U54 >::type >( args[54] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U55 >::type >( args[55] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U56 >::type >( args[56] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 57 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52, U53, U54, U55, U56>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49, typename U50, typename U51, typename U52, typename U53, typename U54, typename U55, typename U56 > class Const_Pointer_CppMethod57 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49, U50 u50, U51 u51, U52 u52, U53 u53, U54 u54, U55 u55, U56 u56) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod57(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U49 >::type >( args[49] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U50 >::type >( args[50] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U51 >::type >( args[51] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U52 >::type >( args[52] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U53 >::type >( args[53] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U54 >::type >( args[54] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U55 >::type >( args[55] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U56 >::type >( args[56] ) ) ) ;
		}
		inline int nargs(){ return 57 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52, U53, U54, U55, U56>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49, typename U50, typename U51, typename U52, typename U53, typename U54, typename U55, typename U56 > class Const_Pointer_CppMethod57<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52, U53, U54, U55, U56> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49, U50 u50, U51 u51, U52 u52, U53 u53, U54 u54, U55 u55, U56 u56) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod57( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U49 >::type >( args[49] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U50 >::type >( args[50] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U51 >::type >( args[51] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U52 >::type >( args[52] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U53 >::type >( args[53] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U54 >::type >( args[54] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U55 >::type >( args[55] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U56 >::type >( args[56] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 57 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52, U53, U54, U55, U56>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49, typename U50, typename U51, typename U52, typename U53, typename U54, typename U55, typename U56, typename U57 > class Pointer_CppMethod58 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49, U50 u50, U51 u51, U52 u52, U53 u53, U54 u54, U55 u55, U56 u56, U57 u57) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod58(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U49 >::type >( args[49] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U50 >::type >( args[50] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U51 >::type >( args[51] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U52 >::type >( args[52] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U53 >::type >( args[53] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U54 >::type >( args[54] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U55 >::type >( args[55] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U56 >::type >( args[56] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U57 >::type >( args[57] ) ) ) ;
		}
		inline int nargs(){ return 58 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52, U53, U54, U55, U56, U57>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49, typename U50, typename U51, typename U52, typename U53, typename U54, typename U55, typename U56, typename U57 > class Pointer_CppMethod58<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52, U53, U54, U55, U56, U57> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49, U50 u50, U51 u51, U52 u52, U53 u53, U54 u54, U55 u55, U56 u56, U57 u57) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod58( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U49 >::type >( args[49] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U50 >::type >( args[50] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U51 >::type >( args[51] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U52 >::type >( args[52] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U53 >::type >( args[53] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U54 >::type >( args[54] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U55 >::type >( args[55] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U56 >::type >( args[56] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U57 >::type >( args[57] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 58 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52, U53, U54, U55, U56, U57>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49, typename U50, typename U51, typename U52, typename U53, typename U54, typename U55, typename U56, typename U57 > class Const_Pointer_CppMethod58 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49, U50 u50, U51 u51, U52 u52, U53 u53, U54 u54, U55 u55, U56 u56, U57 u57) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod58(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U49 >::type >( args[49] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U50 >::type >( args[50] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U51 >::type >( args[51] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U52 >::type >( args[52] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U53 >::type >( args[53] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U54 >::type >( args[54] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U55 >::type >( args[55] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U56 >::type >( args[56] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U57 >::type >( args[57] ) ) ) ;
		}
		inline int nargs(){ return 58 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52, U53, U54, U55, U56, U57>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49, typename U50, typename U51, typename U52, typename U53, typename U54, typename U55, typename U56, typename U57 > class Const_Pointer_CppMethod58<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52, U53, U54, U55, U56, U57> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49, U50 u50, U51 u51, U52 u52, U53 u53, U54 u54, U55 u55, U56 u56, U57 u57) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod58( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U49 >::type >( args[49] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U50 >::type >( args[50] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U51 >::type >( args[51] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U52 >::type >( args[52] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U53 >::type >( args[53] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U54 >::type >( args[54] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U55 >::type >( args[55] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U56 >::type >( args[56] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U57 >::type >( args[57] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 58 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52, U53, U54, U55, U56, U57>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49, typename U50, typename U51, typename U52, typename U53, typename U54, typename U55, typename U56, typename U57, typename U58 > class Pointer_CppMethod59 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49, U50 u50, U51 u51, U52 u52, U53 u53, U54 u54, U55 u55, U56 u56, U57 u57, U58 u58) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod59(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U49 >::type >( args[49] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U50 >::type >( args[50] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U51 >::type >( args[51] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U52 >::type >( args[52] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U53 >::type >( args[53] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U54 >::type >( args[54] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U55 >::type >( args[55] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U56 >::type >( args[56] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U57 >::type >( args[57] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U58 >::type >( args[58] ) ) ) ;
		}
		inline int nargs(){ return 59 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52, U53, U54, U55, U56, U57, U58>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49, typename U50, typename U51, typename U52, typename U53, typename U54, typename U55, typename U56, typename U57, typename U58 > class Pointer_CppMethod59<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52, U53, U54, U55, U56, U57, U58> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49, U50 u50, U51 u51, U52 u52, U53 u53, U54 u54, U55 u55, U56 u56, U57 u57, U58 u58) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod59( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U49 >::type >( args[49] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U50 >::type >( args[50] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U51 >::type >( args[51] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U52 >::type >( args[52] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U53 >::type >( args[53] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U54 >::type >( args[54] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U55 >::type >( args[55] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U56 >::type >( args[56] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U57 >::type >( args[57] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U58 >::type >( args[58] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 59 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52, U53, U54, U55, U56, U57, U58>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49, typename U50, typename U51, typename U52, typename U53, typename U54, typename U55, typename U56, typename U57, typename U58 > class Const_Pointer_CppMethod59 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49, U50 u50, U51 u51, U52 u52, U53 u53, U54 u54, U55 u55, U56 u56, U57 u57, U58 u58) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod59(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U49 >::type >( args[49] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U50 >::type >( args[50] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U51 >::type >( args[51] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U52 >::type >( args[52] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U53 >::type >( args[53] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U54 >::type >( args[54] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U55 >::type >( args[55] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U56 >::type >( args[56] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U57 >::type >( args[57] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U58 >::type >( args[58] ) ) ) ;
		}
		inline int nargs(){ return 59 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52, U53, U54, U55, U56, U57, U58>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49, typename U50, typename U51, typename U52, typename U53, typename U54, typename U55, typename U56, typename U57, typename U58 > class Const_Pointer_CppMethod59<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52, U53, U54, U55, U56, U57, U58> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49, U50 u50, U51 u51, U52 u52, U53 u53, U54 u54, U55 u55, U56 u56, U57 u57, U58 u58) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod59( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U49 >::type >( args[49] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U50 >::type >( args[50] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U51 >::type >( args[51] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U52 >::type >( args[52] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U53 >::type >( args[53] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U54 >::type >( args[54] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U55 >::type >( args[55] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U56 >::type >( args[56] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U57 >::type >( args[57] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U58 >::type >( args[58] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 59 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52, U53, U54, U55, U56, U57, U58>(s, name) ; }
		
	private:
		Method met ;
	} ;





	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49, typename U50, typename U51, typename U52, typename U53, typename U54, typename U55, typename U56, typename U57, typename U58, typename U59 > class Pointer_CppMethod60 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49, U50 u50, U51 u51, U52 u52, U53 u53, U54 u54, U55 u55, U56 u56, U57 u57, U58 u58, U59 u59) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod60(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U49 >::type >( args[49] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U50 >::type >( args[50] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U51 >::type >( args[51] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U52 >::type >( args[52] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U53 >::type >( args[53] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U54 >::type >( args[54] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U55 >::type >( args[55] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U56 >::type >( args[56] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U57 >::type >( args[57] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U58 >::type >( args[58] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U59 >::type >( args[59] ) ) ) ;
		}
		inline int nargs(){ return 60 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52, U53, U54, U55, U56, U57, U58, U59>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49, typename U50, typename U51, typename U52, typename U53, typename U54, typename U55, typename U56, typename U57, typename U58, typename U59 > class Pointer_CppMethod60<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52, U53, U54, U55, U56, U57, U58, U59> : public CppMethod<Class> {
	public:
		typedef void (*Method)(Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49, U50 u50, U51 u51, U52 u52, U53 u53, U54 u54, U55 u55, U56 u56, U57 u57, U58 u58, U59 u59) ;
		typedef CppMethod<Class> method_class ;
		
		Pointer_CppMethod60( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U49 >::type >( args[49] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U50 >::type >( args[50] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U51 >::type >( args[51] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U52 >::type >( args[52] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U53 >::type >( args[53] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U54 >::type >( args[54] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U55 >::type >( args[55] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U56 >::type >( args[56] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U57 >::type >( args[57] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U58 >::type >( args[58] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U59 >::type >( args[59] ) ) ;
			return R_NilValue ;
		}
		inline int nargs(){ return 60 ; }
		inline bool is_void(){ return true ; }
		inline bool is_const(){ return false ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<void_type,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52, U53, U54, U55, U56, U57, U58, U59>(s, name) ; }
		
	private:
		Method met ;
	} ;

	
	// const
	
	template < typename Class, typename OUT, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49, typename U50, typename U51, typename U52, typename U53, typename U54, typename U55, typename U56, typename U57, typename U58, typename U59 > class Const_Pointer_CppMethod60 : public CppMethod<Class> {
	public:
		typedef OUT (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49, U50 u50, U51 u51, U52 u52, U53 u53, U54 u54, U55 u55, U56 u56, U57 u57, U58 u58, U59 u59) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod60(Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			return Rcpp::module_wrap<OUT>( met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U48 >::type >( args[48] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U49 >::type >( args[49] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U50 >::type >( args[50] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U51 >::type >( args[51] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U52 >::type >( args[52] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U53 >::type >( args[53] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U54 >::type >( args[54] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U55 >::type >( args[55] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U56 >::type >( args[56] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U57 >::type >( args[57] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U58 >::type >( args[58] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U59 >::type >( args[59] ) ) ) ;
		}
		inline int nargs(){ return 60 ; }
		inline bool is_void(){ return false ; }
		inline bool is_const(){ return true ; }
		inline void signature(std::string& s, const char* name){ Rcpp::signature<OUT,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52, U53, U54, U55, U56, U57, U58, U59>(s, name) ; }
		
	private:
		Method met ;
	} ;
	
	template < typename Class, typename U0, typename U1, typename U2, typename U3, typename U4, typename U5, typename U6, typename U7, typename U8, typename U9, typename U10, typename U11, typename U12, typename U13, typename U14, typename U15, typename U16, typename U17, typename U18, typename U19, typename U20, typename U21, typename U22, typename U23, typename U24, typename U25, typename U26, typename U27, typename U28, typename U29, typename U30, typename U31, typename U32, typename U33, typename U34, typename U35, typename U36, typename U37, typename U38, typename U39, typename U40, typename U41, typename U42, typename U43, typename U44, typename U45, typename U46, typename U47, typename U48, typename U49, typename U50, typename U51, typename U52, typename U53, typename U54, typename U55, typename U56, typename U57, typename U58, typename U59 > class Const_Pointer_CppMethod60<Class,void,U0, U1, U2, U3, U4, U5, U6, U7, U8, U9, U10, U11, U12, U13, U14, U15, U16, U17, U18, U19, U20, U21, U22, U23, U24, U25, U26, U27, U28, U29, U30, U31, U32, U33, U34, U35, U36, U37, U38, U39, U40, U41, U42, U43, U44, U45, U46, U47, U48, U49, U50, U51, U52, U53, U54, U55, U56, U57, U58, U59> : public CppMethod<Class> {
	public:
		typedef void (*Method)(const Class*, U0 u0, U1 u1, U2 u2, U3 u3, U4 u4, U5 u5, U6 u6, U7 u7, U8 u8, U9 u9, U10 u10, U11 u11, U12 u12, U13 u13, U14 u14, U15 u15, U16 u16, U17 u17, U18 u18, U19 u19, U20 u20, U21 u21, U22 u22, U23 u23, U24 u24, U25 u25, U26 u26, U27 u27, U28 u28, U29 u29, U30 u30, U31 u31, U32 u32, U33 u33, U34 u34, U35 u35, U36 u36, U37 u37, U38 u38, U39 u39, U40 u40, U41 u41, U42 u42, U43 u43, U44 u44, U45 u45, U46 u46, U47 u47, U48 u48, U49 u49, U50 u50, U51 u51, U52 u52, U53 u53, U54 u54, U55 u55, U56 u56, U57 u57, U58 u58, U59 u59) ;
		typedef CppMethod<Class> method_class ;
		
		Const_Pointer_CppMethod60( Method m) : method_class(), met(m){} 
		SEXP operator()( Class* object, SEXP* args){
			met( object, Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U0 >::type >( args[0] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U1 >::type >( args[1] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U2 >::type >( args[2] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U3 >::type >( args[3] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U4 >::type >( args[4] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U5 >::type >( args[5] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U6 >::type >( args[6] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U7 >::type >( args[7] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U8 >::type >( args[8] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U9 >::type >( args[9] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U10 >::type >( args[10] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U11 >::type >( args[11] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U12 >::type >( args[12] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U13 >::type >( args[13] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U14 >::type >( args[14] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U15 >::type >( args[15] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U16 >::type >( args[16] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U17 >::type >( args[17] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U18 >::type >( args[18] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U19 >::type >( args[19] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U20 >::type >( args[20] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U21 >::type >( args[21] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U22 >::type >( args[22] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U23 >::type >( args[23] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U24 >::type >( args[24] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U25 >::type >( args[25] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U26 >::type >( args[26] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U27 >::type >( args[27] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U28 >::type >( args[28] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U29 >::type >( args[29] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U30 >::type >( args[30] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U31 >::type >( args[31] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U32 >::type >( args[32] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U33 >::type >( args[33] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U34 >::type >( args[34] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U35 >::type >( args[35] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U36 >::type >( args[36] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U37 >::type >( args[37] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U38 >::type >( args[38] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U39 >::type >( args[39] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U40 >::type >( args[40] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U41 >::type >( args[41] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U42 >::type >( args[42] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U43 >::type >( args[43] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U44 >::type >( args[44] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U45 >::type >( args[45] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U46 >::type >( args[46] ), Rcpp::as< typename Rcpp::traits::remove_const_and_reference< U47 >::type >( args[47] ), Rcpp::as< typename Rcpp::traits::remove_const