% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleClustering.R
\name{imgClassif}
\alias{imgClassif}
\title{Images clustering}
\usage{
imgClassif(data.sample, imgdir, method, user.name = "")
}
\arguments{
\item{data.sample}{list containing features, profiles and clustering results.}

\item{imgdir}{character vector specifying the path of the images directory.}

\item{method}{character vector specifying the clustering method (already performed) to use.}

\item{user.name}{character vector specifying the user name.}
}
\value{
images files in the different directories, csv file containing the detail.
}
\description{
Sort images (if available) in different directories according to a clustering result.
}
\details{
imgClassif sorts images (if available) in different directories according to a clustering result
}
\examples{
dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))
tf1 <- tempfile()
write.table(dat, tf1, sep=",", dec=".")

rep <- system.file("extdata", package="RclusTool")
imgdir <- file.path(rep, "img_example")

dir.results <- tempdir()
x <- importSample(file.features=tf1, dir.images=imgdir, dir.save=dir.results)
x <- computeUnSupervised(x, K=3, method.name="K-means")

imgClassif(x, imgdir, method = "K-means_preprocessed")


}
\seealso{
\code{\link{sigClassif}}
}
