% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codeSSSC.R
\name{buildConstraintsMatrix}
\alias{buildConstraintsMatrix}
\title{Constraints matrices}
\usage{
buildConstraintsMatrix(n, list.ML = list(), list.CNL = list())
}
\arguments{
\item{n}{total number of observations.}

\item{list.ML}{list of ML (must-link) constrained pairs.}

\item{list.CNL}{list of CNL (cannot-link) constrained pairs.}
}
\value{
C constraints matrix (with 1 for must-link and -1 for cannot-link).
}
\description{
Compute the constraints matrix C, based on ML and CNL sets.
}
\details{
buildConstraintsMatrix generate constraints matrix, based on ML and CNL sets
}
\examples{
dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
           matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
           matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))
           
ML <- list()
ML[[1]] <- c(sel="10",mem="20")
ML[[2]] <- c(sel="60",mem="70")

CNL <- list()
CNL[[1]] <- c(sel="30",mem="80")
CNL[[2]] <- c(sel="90",mem="120")

C <- buildConstraintsMatrix(n=nrow(dat), list.ML=ML, list.CNL=CNL)

}
\keyword{internal}
