% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleBuilding.R
\name{addOperation}
\alias{addOperation}
\title{Add operation}
\usage{
addOperation(parameterList, featureOperations)
}
\arguments{
\item{parameterList, }{list of Preprocessing instructions for an operation.}

\item{featureOperations, }{matrix where to list Operations on features.}
}
\value{
The configuration object created by the list of preprocessing instructions \code{parameterList} in \code{featureOperations}.
}
\description{
addOperation create configuration object for the datasample
}
\examples{
featOp <- matrix(ncol=4,nrow=0)
#Adding two differents variables
featOp <- addOperation(list("+","x","y"), featOp)
#Select a variable
featOp <- addOperation(list("select","x"), featOp)
#Change a profile color
featOp <- addOperation(list("signalColor","x","grey"), featOp)
#Make a PCA projection (with the number of dimensions)
featOp <- addOperation(list("projection","pca","0"), featOp)
#Make a spectral projection
featOp <- addOperation(list("projection","spectral"), featOp)
#Scale the data
featOp <- addOperation(list("scaling","on"), featOp)
#Sample the data (with a sampling size)
featOp <- addOperation(list("sampling","150"), featOp)
#Make a log transformation of a variable
featOp <- addOperation(list("log","x"), featOp)

}
