\name{cell-counter}
\alias{cell-counter}
\alias{cell.counter}
\alias{cardinality.plot}
\alias{map.cells.points}

\title{Map Cell Counter Tags to Cells}
\description{
This functions maps the tags generated by ImageJ plugin Cell Counter to the cells in a cell.data object
}

\usage{
map.cells.points(X,cell.counter,pos=NULL,t.frame=0,...
  ,radius=10,var.name="tag",init.value=NA,map.to.all.t=TRUE)

cardinality.plot(X,cell.counter,pos=NULL,t.frame=0,...
  ,max.radius=30,max.cardinality=3)	
}
\arguments{
  \item{X}{cell.data object }
  \item{cell.counter}{data.frame loaded from Cell Counter output, or a list containing such data.frames. The list index should corresponds to the position number of the image}
  \item{pos}{if \code{cell.counter} is a data.frame, the position it corresponds to. If \code{cell.counter} is a list this argument is not used.}	
  \item{t.frame}{the time frame of the dataset to use for the mapping}	
  \item{\dots}{arguments to be passed to private methods. subset and QC.filter can be specified}	
  \item{radius}{integer radius used for the mapping. It should be a value in the plateau of \code{cardinality.plot}}	
  \item{var.name}{name of the new variable with the tags}	
  \item{init.value}{value assign to cells that where not mapped to any point}
  \item{map.to.all.t}{boolean. if TURE the new variable will be assign to all t.frames, if FALSE only to \code{t.frame} time frame}
  \item{max.radius}{maximum radius to calculate the cardinality}
  \item{max.cardinality}{maximum cardinality to show in the plot}
}
\details{
This functions are used to merge additional data to the Cell-ID dataset. Tags are assign manually to cells using 'Cell Counter' plugin of ImageJ. To do so open the BF or fluorescent image in ImageJ, select Plugins > Analyse > Cell Counter. Click on 'initialize'. A copy of your image should appear. Select 'Point Selection' from ImageJ buttons, and click on the counter type in the Cell Counter window. Mark the cells with the correspondent tag (1,2,3..). Make sure to put the tag close to the center of the cell.

When finished click 'Measure...' in the CellCounter windows. A table with the point Type, X and Y 
position should appear. Save it as a .txt file and take note of the path (for example 
'c:/data/TFP_Pos1_time1.CellCounter.txt'). If you want to save the image with the tags, click on 'Export Image' in CellCounter, and save the 
image.

Back in R, load the CellCounter table

\code{tags1<-read.table('c:/data/TFP_Pos1_time1.CellCounter.txt',head=T)}

The mapping between the points and cells will be done based on the XY position. We need a cut-off radius. If the distance between cell center (determined by Cell-ID) and the point (from CellCounter) is less than the cut-off, the point type will be assigned to the cell. To choose the correct cut-off radius use the \code{cardinality.plot} function

\code{cardinality.plot(X,tags1,pos=1,t.frame=0)}

Choose a radius in the plateau of the cardinality=1 curve (one to one mapping between cells and points). If cut-off radius is to high, some ambiguities will appear in the cell assignation. If cut-off radius is two low, some points won't be assigned to their correspondent cells. Usually radius=10 is a good value. Finally do the mapping

\code{ X<-map.cells.points(X,tags1,pos=1,t.frame=0,radius=10,var.name='tag.type') }

This will add a new variable to the cell.data object named 'tag.type', with the correspondent tag number for each cell of position 1. The same tag will be added to all time points. t.frame specifies which t.frame is used for CellCounter tag assignation.

If you want to add tags for more than one position, you have to two options. The first one is to follow the steps shown above for other positions. Note that usually the same radius works for all positions. 

\code{ tags2<-read.table('c:/data/TFP_Pos2_time1.CellCounter.txt',head=T)}

\code{ X<-map.cells.points(X,tags2,pos=2,t.frame=0,radius=10,var.name='tag.type') }

If you want to reset the assign tags, use the map.cells.points with the 'add' argument set to FALSE.
A second option is to construct a list with each 'Cell Counter' data.frame as an element. The name of the element in the list should correspond to its position. For example if you have the data.frames of positions 1, 2 and 5 loaded in the variables tags1, tags2 and tags5 create a new list and use it as the cell.counter argument.

\code{tags.list<-list(tags1,tags2,tags5)}

\code{names(tags.list)<-c("1","2","5")}

\code{X<-map.cells.points(X,tags.list,t.frame=0,radius=10,var.name='tag.type')}

}
\value{
 a cell.data object with the tags from Cell Counter merged to the data.frame
}
\author{Alan Bush}
\seealso{ \code{\link{transform.cell.data}},  \code{\link{merge.cell.data}}}
\examples{
#load the example dataset
data(ACL394)

#pos1.cell.counter is a cell counter output file for position 1
str(pos1.cell.counter)

#plotting cardinality
cardinality.plot(X,pos1.cell.counter,pos=1)

#do the mapping
X<-map.cells.points(X,pos1.cell.counter,pos=1,radius=10,var.name="cell.type")

#use the new variable for plotting
cplot(X,f.tot.y~t.frame,color=cell.type,subset=pos==1)

}
\keyword{manip}