% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_annual_peak_timing_error.R
\name{rvn_annual_peak_timing_error}
\alias{rvn_annual_peak_timing_error}
\title{Annual Peak Timing Errors}
\usage{
rvn_annual_peak_timing_error(
  sim,
  obs,
  mm = 9,
  dd = 30,
  add_line = TRUE,
  add_labels = TRUE
)
}
\arguments{
\item{sim}{time series object of simulated flows}

\item{obs}{time series object of observed flows}

\item{mm}{month of water year (default 9)}

\item{dd}{day of water year (default 30)}

\item{add_line}{optionally adds a 1:1 line to the plot for reference
(default TRUE)}

\item{add_labels}{optionally adds labels for early peak/late peaks on right
side axis (default TRUE)}
}
\value{
returns a list with peak timing errors in a data frame, and a ggplot object
 \item{df_peak_timing_error}{data frame of the calculated peak timing errors}
 \item{p1}{ggplot object with plotted annual peak errors}
}
\description{
rvn_annual_peak_timing_error creates a plot of the annual observed and simulated
peak timing errors, based on the water year.
}
\details{
This function creates a plot of the peak timing errors in simulated peaks
for each water year. The difference in days between the simulated peak and
observed peak are plotted (and/or returned in the data frame) for the water
year. This diagnostic is useful in determining how accurate the timing of
peak predictions is. Note that a large error in the number of days between
simulated and observed peaks indicates that the model predicted a larger
event at a different time of year, i.e. overestimated a different event or
underestimated the actual peak event, relative to the observed flow series.

The sim and obs should be of time series (xts) format and are assumed to be
of the same length and time period. The flow series are assumed to be daily
flows with units of m3/s. Note that a plot title is purposely omitted in
order to allow the automatic generation of plot titles.

The add_labels will add the labels of 'early peak' and 'late peak' to the
right hand side axis if set to TRUE. This is useful in interpreting the
plots. Note that values in this metric of less than zero indicate an early
prediction of the peak, and positive values mean a late prediction of the
peak (since the values are calculated as day index of simulated peak - day
index of observed peak).
}
\examples{
# load sample hydrograph data, two years worth of sim/obs
data(rvn_hydrograph_data)
sim <- rvn_hydrograph_data$hyd$Sub36
obs <- rvn_hydrograph_data$hyd$Sub36_obs

# create a plot of peak timing errors with defaults
peak1 <- rvn_annual_peak_timing_error(sim, obs, add_line=TRUE)
peak1$df_peak_timing_error
peak1$p1

# plot directly and without labels
rvn_annual_peak_timing_error(sim, obs, add_line=TRUE, add_labels=FALSE)


}
\seealso{
\code{\link{rvn_annual_peak_event}} to consider the timing of peak
events \code{\link{rvn_annual_peak_event_error}} to calculate errors in peak
events
}
