% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_expected_vs_observed.R
\name{compare_expected_vs_observed}
\alias{compare_expected_vs_observed}
\title{Compare the observed frequencies of combinations with their expected frequencies under the assumption of independence within a single group}
\usage{
compare_expected_vs_observed(boolean_input_df, combo_length, min_indv_threshold,
                             max_freq_threshold, input_format,
                             pval_filter_threshold, adj_pval_type)
}
\arguments{
\item{boolean_input_df}{An input Boolean dataframe with multiple input variables}

\item{combo_length}{The length of the combinations specified by the user}

\item{min_indv_threshold}{Minimum number of instances that support the combination}

\item{max_freq_threshold}{Maximum fraction of the cohort size that could support a combination (i.e., filter out highly frequent events)}

\item{input_format}{Optional | Naming convention used for input variables (Default = 'Input_')}

\item{pval_filter_threshold}{Optional | p-value cut-off to use for multiple testing adjustment (Default = 0.05)}

\item{adj_pval_type}{Optional | Type of multiple testing corrections to use (Default = 'BH'; Alternative option = 'bonferroni')}
}
\value{
A dataframe with the list of multiple-testing adjusted statistically significant combinations
        along with quantitative measures (frequencies, p-values etc) that support the findings.
}
\description{
This function takes a Boolean dataframe as input and compares the observed frequency of combinations
that meet the criteria specified by the users with their corresponding expectation derived
under the assumption of independence between the constituent elements of each combination
}
\examples{

   compare_expected_vs_observed(boolean_input_df, 2, 10, 0.25, 0.05,
                                input_format = 'Input_', adj_pval_type = 'BH')


}
\author{
Vijay Kumar Pounraja
}
