% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vec-cumulative-functions.R
\name{skewness_vec}
\alias{skewness_vec}
\title{Compute Skewness of a Vector}
\usage{
skewness_vec(.x)
}
\arguments{
\item{.x}{A numeric vector of length four or more.}
}
\value{
The skewness of a vector
}
\description{
This function takes in a vector as it's input and will return the skewness
of that vector. The length of this vector must be at least four numbers. The
skewness explains the 'tailedness' of the distribution of data.

\verb{((1/n) * sum(x - mu\})^3) / ((()1/n) * sum(x - mu)^2)^(3/2)}
}
\details{
A function to return the skewness of a vector.
}
\examples{
set.seed(123)
skewness_vec(rnorm(100, 3, 2))

}
\seealso{
\url{https://en.wikipedia.org/wiki/Skewness}

Other Vector Function: 
\code{\link{cgmean}()},
\code{\link{chmean}()},
\code{\link{ckurtosis}()},
\code{\link{cmean}()},
\code{\link{cmedian}()},
\code{\link{crange}()},
\code{\link{csd}()},
\code{\link{cskewness}()},
\code{\link{cvar}()},
\code{\link{euclidean_distance}()},
\code{\link{kurtosis_vec}()},
\code{\link{rw_range}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Vector Function}
